import operator

from django.db.backends.base.features import BaseDatabaseFeatures
from django.db.utils import InterfaceError
from django.utils.functional import cached_property


class DatabaseFeatures(BaseDatabaseFeatures):
    allows_group_by_selected_pks = True
    can_return_id_from_insert = True
    can_return_ids_from_bulk_insert = True
    has_real_datatype = True
    has_native_uuid_field = True
    has_native_duration_field = True
    can_defer_constraint_checks = True
    has_select_for_update = True
    has_select_for_update_nowait = True
    has_select_for_update_of = True
    can_release_savepoints = True
    supports_tablespaces = True
    supports_transactions = True
    can_introspect_autofield = True
    can_introspect_ip_address_field = True
    can_introspect_materialized_views = True
    can_introspect_small_integer_field = True
    can_distinct_on_fields = True
    can_rollback_ddl = True
    supports_combined_alters = True
    nulls_order_largest = True
    closed_cursor_error_class = InterfaceError
    has_case_insensitive_like = False
    greatest_least_ignores_nulls = True
    can_clone_databases = True
    supports_temporal_subtraction = True
    supports_slicing_ordering_in_compound = True
    create_test_procedure_without_params_sql = """
        CREATE FUNCTION test_procedure () RETURNS void AS $$
        DECLARE
            V_I INTEGER;
        BEGIN
            V_I := 1;
        END;
    $$ LANGUAGE plpgsql;"""
    create_test_procedure_with_int_param_sql = """
        CREATE FUNCTION test_procedure (P_I INTEGER) RETURNS void AS $$
        DECLARE
            V_I INTEGER;
        BEGIN
            V_I := P_I;
        END;
    $$ LANGUAGE plpgsql;"""
    requires_casted_case_in_updates = True
    supports_over_clause = True
    supports_aggregate_filter_clause = True
    supported_explain_formats = {'JSON', 'TEXT', 'XML', 'YAML'}
    validates_explain_options = False  # A query will error on invalid options.

    @cached_property
    def is_postgresql_9_5(self):
        return self.connection.pg_version >= 90500

    @cached_property
    def is_postgresql_9_6(self):
        return self.connection.pg_version >= 90600

    @cached_property
    def is_postgresql_10(self):
        return self.connection.pg_version >= 100000

    has_select_for_update_skip_locked = property(operator.attrgetter('is_postgresql_9_5'))
    has_brin_index_support = property(operator.attrgetter('is_postgresql_9_5'))
    has_jsonb_agg = property(operator.attrgetter('is_postgresql_9_5'))
    has_brin_autosummarize = property(operator.attrgetter('is_postgresql_10'))
    has_gin_pending_list_limit = property(operator.attrgetter('is_postgresql_9_5'))
    supports_ignore_conflicts = property(operator.attrgetter('is_postgresql_9_5'))
    has_phraseto_tsquery = property(operator.attrgetter('is_postgresql_9_6'))
    supports_table_partitions = property(operator.attrgetter('is_postgresql_10'))
