//
// This file enforces partial GSP ABI stability within a release branch
//
// If you are hitting one of the asserts here, this means your changes end up
// breaking the ABI between the GSP and the CPU in a way that will break other
// kernel drivers such as nouveau.
//
// Please see bug 5095544 for more details.
//
// This file was generated automatically, but may have had further manual
// changes applied to it. Check bug 5095544 and p4 history.
//

#define RPC_STRUCTURES
#include "g_rpc-structures.h"
#include "g_sdk-structures.h"
#include <nvos.h>
#include <alloc/alloc_channel.h>
#include <class/cl0000.h>
#include <class/cl0005.h>
#include <class/cl0073.h>
#include <class/cl0080.h>
#include <class/cl2080.h>
#include <class/cl2080_notification.h>
#include <class/cl84a0.h>
#include <class/cl90f1.h>
#include <class/clc0b5sw.h>
#include <ctrl/ctrl0073/ctrl0073dp.h>
#include <ctrl/ctrl0073/ctrl0073common.h>
#include <ctrl/ctrl0073/ctrl0073system.h>
#include <ctrl/ctrl0073/ctrl0073specific.h>
#include <ctrl/ctrl0073/ctrl0073dfp.h>
#include <ctrl/ctrl0080/ctrl0080gr.h>
#include <ctrl/ctrl0080/ctrl0080fifo.h>
#include <ctrl/ctrl0080/ctrl0080gpu.h>
#include <ctrl/ctrl90f1.h>
#include <ctrl/ctrla06f/ctrla06fgpfifo.h>
#include <ctrl/ctrl2080/ctrl2080fifo.h>
#include <ctrl/ctrl2080/ctrl2080bios.h>
#include <ctrl/ctrl2080/ctrl2080fb.h>
#include <ctrl/ctrl2080/ctrl2080gpu.h>
#include <ctrl/ctrl2080/ctrl2080gr.h>
#include <ctrl/ctrl2080/ctrl2080event.h>
#include <ctrl/ctrl2080/ctrl2080internal.h>
#include <ctrl/ctrl2080/ctrl2080ce.h>
#include "gpu/gsp/gsp_static_config.h"
#include "gsp/gsp_fw_wpr_meta.h"
#include "gsp/gsp_fw_sr_meta.h"
#include "gpu/gsp/gsp_fw_heap.h"
#include "gpu/gsp/gsp_init_args.h"
#include "gpu/gsp/kernel_gsp.h"
#include "rmgspseq.h"
#include "libos_init_args.h"
#include "rmRiscvUcode.h"
#include "msgq/msgq_priv.h"
#include "gpu/fifo/kernel_channel.h"
#include "gpu/mem_mgr/fbsr.h"


#include <nvctassert.h>
#define ABI_CHECK_SIZE_EQ(str, size)                 ct_assert(sizeof(str) == size)
#define ABI_CHECK_SIZE_GE(str, size)                 ct_assert(sizeof(str) >= size)
#define ABI_CHECK_ENUM_VAL_EQ(enumname, name, value) ct_assert(name == value)
#define ABI_CHECK_ENUM_VAL_GE(enumname, name, value) ct_assert(name >= value)
#define ABI_CHECK_OFFSET(str, fld, offset)           ct_assert(NV_OFFSETOF(str, fld) == offset)
#define ABI_CHECK_FIELD(str, fld, offset, size)      \
    ABI_CHECK_OFFSET(str, fld, offset);              \
    ABI_CHECK_SIZE_EQ((((str*)0)->fld), size)
#define ABI_CHECK_FIELD_FLEXIBLE(str, fld, offset)   \
    ABI_CHECK_OFFSET(str, fld, offset);              \
    ct_assert(offset <= sizeof(str))


ABI_CHECK_SIZE_EQ(ACPI_METHOD_DATA, 676);
ABI_CHECK_FIELD(ACPI_METHOD_DATA, bValid, 0, 1);
ABI_CHECK_FIELD(ACPI_METHOD_DATA, dodMethodData, 4, 72);
ABI_CHECK_FIELD(ACPI_METHOD_DATA, jtMethodData, 76, 12);
ABI_CHECK_FIELD(ACPI_METHOD_DATA, muxMethodData, 88, 580);
ABI_CHECK_FIELD(ACPI_METHOD_DATA, capsMethodData, 668, 8);

#define ADDR_FBMEM 2
#define ADDR_SYSMEM 1

ABI_CHECK_SIZE_EQ(BUSINFO, 10);
ABI_CHECK_FIELD(BUSINFO, deviceID, 0, 2);
ABI_CHECK_FIELD(BUSINFO, vendorID, 2, 2);
ABI_CHECK_FIELD(BUSINFO, subdeviceID, 4, 2);
ABI_CHECK_FIELD(BUSINFO, subvendorID, 6, 2);
ABI_CHECK_FIELD(BUSINFO, revisionID, 8, 1);


ABI_CHECK_SIZE_EQ(CAPS_METHOD_DATA, 8);
ABI_CHECK_FIELD(CAPS_METHOD_DATA, status, 0, 4);
ABI_CHECK_FIELD(CAPS_METHOD_DATA, optimusCaps, 4, 4);


ABI_CHECK_ENUM_VAL_EQ(COMPUTE_BRANDING_TYPE, COMPUTE_BRANDING_TYPE_NONE, 0);
ABI_CHECK_ENUM_VAL_EQ(COMPUTE_BRANDING_TYPE, COMPUTE_BRANDING_TYPE_TESLA, 1);



ABI_CHECK_SIZE_EQ(DOD_METHOD_DATA, 72);
ABI_CHECK_FIELD(DOD_METHOD_DATA, status, 0, 4);
ABI_CHECK_FIELD(DOD_METHOD_DATA, acpiIdListLen, 4, 4);
ABI_CHECK_FIELD(DOD_METHOD_DATA, acpiIdList, 8, 64);


ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_ENG_DESC, 0);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_FIFO_TAG, 1);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_RM_ENGINE_TYPE, 2);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_RUNLIST, 3);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_MMU_FAULT_ID, 4);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_RC_MASK, 5);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_RESET, 6);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_INTR, 7);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_MC, 8);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_DEV_TYPE_ENUM, 9);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_INSTANCE_ID, 10);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_RUNLIST_PRI_BASE, 11);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_IS_HOST_DRIVEN_ENGINE, 12);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_RUNLIST_ENGINE_ID, 13);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_CHRAM_PRI_BASE, 14);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_KERNEL_RM_MAX, 15);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_INVALID, 15);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_ENGINE_DATA_ARRAY_SIZE, 15);
ABI_CHECK_ENUM_VAL_EQ(ENGINE_INFO_TYPE, ENGINE_INFO_TYPE_PBDMA_ID, 16);



ABI_CHECK_ENUM_VAL_EQ(ErrorNotifierType, ERROR_NOTIFIER_TYPE_UNKNOWN, 0);
ABI_CHECK_ENUM_VAL_EQ(ErrorNotifierType, ERROR_NOTIFIER_TYPE_NONE, 1);
ABI_CHECK_ENUM_VAL_EQ(ErrorNotifierType, ERROR_NOTIFIER_TYPE_CTXDMA, 2);
ABI_CHECK_ENUM_VAL_EQ(ErrorNotifierType, ERROR_NOTIFIER_TYPE_MEMORY, 3);


#define FBSR_TYPE_DMA 4
#define FERMI_VASPACE_A (0x000090f1)

ABI_CHECK_SIZE_EQ(GSP_ARGUMENTS_CACHED, 72);
ABI_CHECK_FIELD(GSP_ARGUMENTS_CACHED, messageQueueInitArguments, 0, 32);
ABI_CHECK_FIELD(GSP_ARGUMENTS_CACHED, srInitArguments, 32, 12);
ABI_CHECK_FIELD(GSP_ARGUMENTS_CACHED, gpuInstance, 44, 4);
ABI_CHECK_FIELD(GSP_ARGUMENTS_CACHED, bDmemStack, 48, 1);
ABI_CHECK_FIELD(GSP_ARGUMENTS_CACHED, profilerArgs, 56, 16);

#define GSP_FW_HEAP_PARAM_BASE_RM_SIZE_GH100 (14 << 20)
#define GSP_FW_HEAP_PARAM_BASE_RM_SIZE_TU10X (8 << 20)
#define GSP_FW_HEAP_PARAM_CLIENT_ALLOC_SIZE ((48 << 10) * 2048)
#define GSP_FW_HEAP_PARAM_OS_SIZE_LIBOS2 (0 << 20)
#define GSP_FW_HEAP_PARAM_OS_SIZE_LIBOS3_BAREMETAL (22 << 20)
#define GSP_FW_HEAP_PARAM_SIZE_PER_GB_FB (96 << 10)
#define GSP_FW_HEAP_SIZE_OVERRIDE_LIBOS2_MAX_MB (256u)
#define GSP_FW_HEAP_SIZE_OVERRIDE_LIBOS2_MIN_MB (64u)
#define GSP_FW_HEAP_SIZE_OVERRIDE_LIBOS3_BAREMETAL_MAX_MB (280u)
#define GSP_FW_HEAP_SIZE_OVERRIDE_LIBOS3_BAREMETAL_MIN_MB (88u)
#define GSP_FW_SR_META_MAGIC 0x8a3bb9e6c6c39d93ULL
#define GSP_FW_SR_META_REVISION 2
#define GSP_FW_WPR_META_MAGIC 0xdc3aae21371a60b3ULL
#define GSP_FW_WPR_META_REVISION 1

ABI_CHECK_SIZE_EQ(GSP_SEQUENCER_BUFFER_CMD, 24);
ABI_CHECK_FIELD(GSP_SEQUENCER_BUFFER_CMD, opCode, 0, 4);
ABI_CHECK_FIELD(GSP_SEQUENCER_BUFFER_CMD, payload, 4, 20);


ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_REG_WRITE, 0);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_REG_MODIFY, 1);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_REG_POLL, 2);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_DELAY_US, 3);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_REG_STORE, 4);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_CORE_RESET, 5);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_CORE_START, 6);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_CORE_WAIT_FOR_HALT, 7);
ABI_CHECK_ENUM_VAL_EQ(GSP_SEQ_BUF_OPCODE, GSP_SEQ_BUF_OPCODE_CORE_RESUME, 8);



ABI_CHECK_SIZE_EQ(GSP_SEQ_BUF_PAYLOAD_DELAY_US, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_DELAY_US, val, 0, 4);


ABI_CHECK_SIZE_EQ(GSP_SEQ_BUF_PAYLOAD_REG_MODIFY, 12);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_MODIFY, addr, 0, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_MODIFY, mask, 4, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_MODIFY, val, 8, 4);


ABI_CHECK_SIZE_EQ(GSP_SEQ_BUF_PAYLOAD_REG_POLL, 20);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_POLL, addr, 0, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_POLL, mask, 4, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_POLL, val, 8, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_POLL, timeout, 12, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_POLL, error, 16, 4);


ABI_CHECK_SIZE_EQ(GSP_SEQ_BUF_PAYLOAD_REG_STORE, 8);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_STORE, addr, 0, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_STORE, index, 4, 4);


ABI_CHECK_SIZE_EQ(GSP_SEQ_BUF_PAYLOAD_REG_WRITE, 8);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_WRITE, addr, 0, 4);
ABI_CHECK_FIELD(GSP_SEQ_BUF_PAYLOAD_REG_WRITE, val, 4, 4);


ABI_CHECK_SIZE_EQ(GSP_SR_INIT_ARGUMENTS, 12);
ABI_CHECK_FIELD(GSP_SR_INIT_ARGUMENTS, oldLevel, 0, 4);
ABI_CHECK_FIELD(GSP_SR_INIT_ARGUMENTS, flags, 4, 4);
ABI_CHECK_FIELD(GSP_SR_INIT_ARGUMENTS, bInPMTransition, 8, 1);


ABI_CHECK_SIZE_EQ(GSP_VF_INFO, 40);
ABI_CHECK_FIELD(GSP_VF_INFO, totalVFs, 0, 4);
ABI_CHECK_FIELD(GSP_VF_INFO, firstVFOffset, 4, 4);
ABI_CHECK_FIELD(GSP_VF_INFO, FirstVFBar0Address, 8, 8);
ABI_CHECK_FIELD(GSP_VF_INFO, FirstVFBar1Address, 16, 8);
ABI_CHECK_FIELD(GSP_VF_INFO, FirstVFBar2Address, 24, 8);
ABI_CHECK_FIELD(GSP_VF_INFO, b64bitBar0, 32, 1);
ABI_CHECK_FIELD(GSP_VF_INFO, b64bitBar1, 33, 1);
ABI_CHECK_FIELD(GSP_VF_INFO, b64bitBar2, 34, 1);


ABI_CHECK_SIZE_EQ(GspFwSRMeta, 256);
ABI_CHECK_FIELD(GspFwSRMeta, magic, 0, 8);
ABI_CHECK_FIELD(GspFwSRMeta, revision, 8, 8);
ABI_CHECK_FIELD(GspFwSRMeta, sysmemAddrOfSuspendResumeData, 16, 8);
ABI_CHECK_FIELD(GspFwSRMeta, sizeOfSuspendResumeData, 24, 8);
ABI_CHECK_FIELD(GspFwSRMeta, internal, 32, 128);
ABI_CHECK_FIELD(GspFwSRMeta, flags, 160, 4);
ABI_CHECK_FIELD(GspFwSRMeta, subrevision, 164, 4);
ABI_CHECK_FIELD(GspFwSRMeta, padding, 168, 88);


ABI_CHECK_SIZE_EQ(GspFwWprMeta, 256);
ABI_CHECK_FIELD(GspFwWprMeta, magic, 0, 8);
ABI_CHECK_FIELD(GspFwWprMeta, revision, 8, 8);
ABI_CHECK_FIELD(GspFwWprMeta, sysmemAddrOfRadix3Elf, 16, 8);
ABI_CHECK_FIELD(GspFwWprMeta, sizeOfRadix3Elf, 24, 8);
ABI_CHECK_FIELD(GspFwWprMeta, sysmemAddrOfBootloader, 32, 8);
ABI_CHECK_FIELD(GspFwWprMeta, sizeOfBootloader, 40, 8);
ABI_CHECK_FIELD(GspFwWprMeta, bootloaderCodeOffset, 48, 8);
ABI_CHECK_FIELD(GspFwWprMeta, bootloaderDataOffset, 56, 8);
ABI_CHECK_FIELD(GspFwWprMeta, bootloaderManifestOffset, 64, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwRsvdStart, 88, 8);
ABI_CHECK_FIELD(GspFwWprMeta, nonWprHeapOffset, 96, 8);
ABI_CHECK_FIELD(GspFwWprMeta, nonWprHeapSize, 104, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwWprStart, 112, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwHeapOffset, 120, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwHeapSize, 128, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwOffset, 136, 8);
ABI_CHECK_FIELD(GspFwWprMeta, bootBinOffset, 144, 8);
ABI_CHECK_FIELD(GspFwWprMeta, frtsOffset, 152, 8);
ABI_CHECK_FIELD(GspFwWprMeta, frtsSize, 160, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwWprEnd, 168, 8);
ABI_CHECK_FIELD(GspFwWprMeta, fbSize, 176, 8);
ABI_CHECK_FIELD(GspFwWprMeta, vgaWorkspaceOffset, 184, 8);
ABI_CHECK_FIELD(GspFwWprMeta, vgaWorkspaceSize, 192, 8);
ABI_CHECK_FIELD(GspFwWprMeta, bootCount, 200, 8);
ABI_CHECK_FIELD(GspFwWprMeta, gspFwHeapVfPartitionCount, 240, 1);
ABI_CHECK_FIELD(GspFwWprMeta, flags, 241, 1);
ABI_CHECK_FIELD(GspFwWprMeta, padding, 242, 2);
ABI_CHECK_FIELD(GspFwWprMeta, pmuReservedSize, 244, 4);
ABI_CHECK_FIELD(GspFwWprMeta, verified, 248, 8);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(GspStaticConfigInfo, 1656);
ABI_CHECK_FIELD(GspStaticConfigInfo, grCapsBits, 0, 23);
ABI_CHECK_FIELD(GspStaticConfigInfo, gidInfo, 24, 268);
ABI_CHECK_FIELD(GspStaticConfigInfo, SKUInfo, 292, 48);
ABI_CHECK_FIELD(GspStaticConfigInfo, fbRegionInfoParams, 344, 776);
ABI_CHECK_FIELD(GspStaticConfigInfo, sriovCaps, 1120, 80);
ABI_CHECK_FIELD(GspStaticConfigInfo, sriovMaxGfid, 1200, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, engineCaps, 1204, 12);
ABI_CHECK_FIELD(GspStaticConfigInfo, poisonFuseEnabled, 1216, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, fb_length, 1224, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, fbio_mask, 1232, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, fb_bus_width, 1240, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, fb_ram_type, 1244, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, fbp_mask, 1248, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, l2_cache_size, 1256, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, gpuNameString, 1260, 64);
ABI_CHECK_FIELD(GspStaticConfigInfo, gpuShortNameString, 1324, 64);
ABI_CHECK_FIELD(GspStaticConfigInfo, gpuNameString_Unicode, 1388, 128);
ABI_CHECK_FIELD(GspStaticConfigInfo, bGpuInternalSku, 1516, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsQuadroGeneric, 1517, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsQuadroAd, 1518, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsNvidiaNvs, 1519, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsVgx, 1520, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bGeforceSmb, 1521, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsTitan, 1522, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsTesla, 1523, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsMobile, 1524, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsGc6Rtd3Allowed, 1525, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsGc8Rtd3Allowed, 1526, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsGcOffRtd3Allowed, 1527, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsGcoffLegacyAllowed, 1528, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsMigSupported, 1529, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, RTD3GC6TotalBoardPower, 1530, 2);
ABI_CHECK_FIELD(GspStaticConfigInfo, RTD3GC6PerstDelay, 1532, 2);
ABI_CHECK_FIELD(GspStaticConfigInfo, bar1PdeBase, 1536, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, bar2PdeBase, 1544, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, bVbiosValid, 1552, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, vbiosSubVendor, 1556, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, vbiosSubDevice, 1560, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, bPageRetirementSupported, 1564, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bSplitVasBetweenServerClientRm, 1565, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bClRootportNeedsNosnoopWAR, 1566, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, displaylessMaxHeads, 1568, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, displaylessMaxResolution, 1576, 12);
ABI_CHECK_FIELD(GspStaticConfigInfo, displaylessMaxPixels, 1592, 8);
ABI_CHECK_FIELD(GspStaticConfigInfo, hInternalClient, 1600, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, hInternalDevice, 1604, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, hInternalSubdevice, 1608, 4);
ABI_CHECK_FIELD(GspStaticConfigInfo, bSelfHostedMode, 1612, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bAtsSupported, 1613, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsGpuUefi, 1614, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, bIsEfiInit, 1615, 1);
ABI_CHECK_FIELD(GspStaticConfigInfo, ecidInfo, 1616, 24);
ABI_CHECK_FIELD(GspStaticConfigInfo, fwWprLayoutOffset, 1640, 16);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(GspSystemInfo, 920);
ABI_CHECK_FIELD(GspSystemInfo, gpuPhysAddr, 0, 8);
ABI_CHECK_FIELD(GspSystemInfo, gpuPhysFbAddr, 8, 8);
ABI_CHECK_FIELD(GspSystemInfo, gpuPhysInstAddr, 16, 8);
ABI_CHECK_FIELD(GspSystemInfo, gpuPhysIoAddr, 24, 8);
ABI_CHECK_FIELD(GspSystemInfo, nvDomainBusDeviceFunc, 32, 8);
ABI_CHECK_FIELD(GspSystemInfo, simAccessBufPhysAddr, 40, 8);
ABI_CHECK_FIELD(GspSystemInfo, notifyOpSharedSurfacePhysAddr, 48, 8);
ABI_CHECK_FIELD(GspSystemInfo, pcieAtomicsOpMask, 56, 8);
ABI_CHECK_FIELD(GspSystemInfo, consoleMemSize, 64, 8);
ABI_CHECK_FIELD(GspSystemInfo, maxUserVa, 72, 8);
ABI_CHECK_FIELD(GspSystemInfo, pciConfigMirrorBase, 80, 4);
ABI_CHECK_FIELD(GspSystemInfo, pciConfigMirrorSize, 84, 4);
ABI_CHECK_FIELD(GspSystemInfo, PCIDeviceID, 88, 4);
ABI_CHECK_FIELD(GspSystemInfo, PCISubDeviceID, 92, 4);
ABI_CHECK_FIELD(GspSystemInfo, PCIRevisionID, 96, 4);
ABI_CHECK_FIELD(GspSystemInfo, pcieAtomicsCplDeviceCapMask, 100, 4);
ABI_CHECK_FIELD(GspSystemInfo, oorArch, 104, 1);
ABI_CHECK_FIELD(GspSystemInfo, clPdbProperties, 112, 8);
ABI_CHECK_FIELD(GspSystemInfo, Chipset, 120, 4);
ABI_CHECK_FIELD(GspSystemInfo, bGpuBehindBridge, 124, 1);
ABI_CHECK_FIELD(GspSystemInfo, bFlrSupported, 125, 1);
ABI_CHECK_FIELD(GspSystemInfo, b64bBar0Supported, 126, 1);
ABI_CHECK_FIELD(GspSystemInfo, bMnocAvailable, 127, 1);
ABI_CHECK_FIELD(GspSystemInfo, chipsetL1ssEnable, 128, 4);
ABI_CHECK_FIELD(GspSystemInfo, bUpstreamL0sUnsupported, 132, 1);
ABI_CHECK_FIELD(GspSystemInfo, bUpstreamL1Unsupported, 133, 1);
ABI_CHECK_FIELD(GspSystemInfo, bUpstreamL1PorSupported, 134, 1);
ABI_CHECK_FIELD(GspSystemInfo, bUpstreamL1PorMobileOnly, 135, 1);
ABI_CHECK_FIELD(GspSystemInfo, bSystemHasMux, 136, 1);
ABI_CHECK_FIELD(GspSystemInfo, upstreamAddressValid, 137, 1);
ABI_CHECK_FIELD(GspSystemInfo, FHBBusInfo, 138, 10);
ABI_CHECK_FIELD(GspSystemInfo, chipsetIDInfo, 148, 10);
ABI_CHECK_FIELD(GspSystemInfo, acpiMethodData, 160, 676);
ABI_CHECK_FIELD(GspSystemInfo, hypervisorType, 836, 4);
ABI_CHECK_FIELD(GspSystemInfo, bIsPassthru, 840, 1);
ABI_CHECK_FIELD(GspSystemInfo, sysTimerOffsetNs, 848, 8);
ABI_CHECK_FIELD(GspSystemInfo, gspVFInfo, 856, 40);
ABI_CHECK_FIELD(GspSystemInfo, bIsPrimary, 896, 1);
ABI_CHECK_FIELD(GspSystemInfo, isGridBuild, 897, 1);
ABI_CHECK_FIELD(GspSystemInfo, pcieConfigReg, 900, 4);
ABI_CHECK_FIELD(GspSystemInfo, gridBuildCsp, 904, 4);
ABI_CHECK_FIELD(GspSystemInfo, bPreserveVideoMemoryAllocations, 908, 1);
ABI_CHECK_FIELD(GspSystemInfo, bTdrEventSupported, 909, 1);
ABI_CHECK_FIELD(GspSystemInfo, bFeatureStretchVblankCapable, 910, 1);
ABI_CHECK_FIELD(GspSystemInfo, bEnableDynamicGranularityPageArrays, 911, 1);
ABI_CHECK_FIELD(GspSystemInfo, bClockBoostSupported, 912, 1);
ABI_CHECK_FIELD(GspSystemInfo, bRouteDispIntrsToCPU, 913, 1);


ABI_CHECK_SIZE_EQ(JT_METHOD_DATA, 12);
ABI_CHECK_FIELD(JT_METHOD_DATA, status, 0, 4);
ABI_CHECK_FIELD(JT_METHOD_DATA, jtCaps, 4, 4);
ABI_CHECK_FIELD(JT_METHOD_DATA, jtRevId, 8, 2);
ABI_CHECK_FIELD(JT_METHOD_DATA, bSBIOSCaps, 10, 1);


ABI_CHECK_ENUM_VAL_EQ(LOGIDX, LOGIDX_INIT, 0);
ABI_CHECK_ENUM_VAL_EQ(LOGIDX, LOGIDX_INTR, 1);
ABI_CHECK_ENUM_VAL_EQ(LOGIDX, LOGIDX_RM, 2);
ABI_CHECK_ENUM_VAL_EQ(LOGIDX, LOGIDX_KERNEL, 3);
ABI_CHECK_ENUM_VAL_EQ(LOGIDX, LOGIDX_MNOC, 4);
ABI_CHECK_ENUM_VAL_EQ(LOGIDX, LOGIDX_SIZE, 5);



ABI_CHECK_SIZE_EQ(LibosMemoryRegionInitArgument, 32);
ABI_CHECK_FIELD(LibosMemoryRegionInitArgument, id8, 0, 8);
ABI_CHECK_FIELD(LibosMemoryRegionInitArgument, pa, 8, 8);
ABI_CHECK_FIELD(LibosMemoryRegionInitArgument, size, 16, 8);
ABI_CHECK_FIELD(LibosMemoryRegionInitArgument, kind, 24, 1);
ABI_CHECK_FIELD(LibosMemoryRegionInitArgument, loc, 25, 1);


ABI_CHECK_ENUM_VAL_EQ(LibosMemoryRegionKind, LIBOS_MEMORY_REGION_NONE, 0);
ABI_CHECK_ENUM_VAL_EQ(LibosMemoryRegionKind, LIBOS_MEMORY_REGION_CONTIGUOUS, 1);
ABI_CHECK_ENUM_VAL_EQ(LibosMemoryRegionKind, LIBOS_MEMORY_REGION_RADIX3, 2);



ABI_CHECK_ENUM_VAL_EQ(LibosMemoryRegionLoc, LIBOS_MEMORY_REGION_LOC_NONE, 0);
ABI_CHECK_ENUM_VAL_EQ(LibosMemoryRegionLoc, LIBOS_MEMORY_REGION_LOC_SYSMEM, 1);
ABI_CHECK_ENUM_VAL_EQ(LibosMemoryRegionLoc, LIBOS_MEMORY_REGION_LOC_FB, 2);


#define MC_ENGINE_IDX_ACCESS_CNTR 60
#define MC_ENGINE_IDX_BIF 11
#define MC_ENGINE_IDX_BLG 76
#define MC_ENGINE_IDX_BSP 65
#define MC_ENGINE_IDX_BUF_RESET 78
#define MC_ENGINE_IDX_BUS 7
#define MC_ENGINE_IDX_C2C 42
#define MC_ENGINE_IDX_CE(x) (MC_ENGINE_IDX_CE0 + (x))
#define MC_ENGINE_IDX_CE0 15
#define MC_ENGINE_IDX_CE1 16
#define MC_ENGINE_IDX_CE10 25
#define MC_ENGINE_IDX_CE11 26
#define MC_ENGINE_IDX_CE12 27
#define MC_ENGINE_IDX_CE13 28
#define MC_ENGINE_IDX_CE14 29
#define MC_ENGINE_IDX_CE15 30
#define MC_ENGINE_IDX_CE16 31
#define MC_ENGINE_IDX_CE17 32
#define MC_ENGINE_IDX_CE18 33
#define MC_ENGINE_IDX_CE19 34
#define MC_ENGINE_IDX_CE2 17
#define MC_ENGINE_IDX_CE3 18
#define MC_ENGINE_IDX_CE4 19
#define MC_ENGINE_IDX_CE5 20
#define MC_ENGINE_IDX_CE6 21
#define MC_ENGINE_IDX_CE7 22
#define MC_ENGINE_IDX_CE8 23
#define MC_ENGINE_IDX_CE9 24
#define MC_ENGINE_IDX_CE_MAX MC_ENGINE_IDX_CE19
#define MC_ENGINE_IDX_CIPHER 10
#define MC_ENGINE_IDX_CPU_DOORBELL 73
#define MC_ENGINE_IDX_DISP 2
#define MC_ENGINE_IDX_DISP_GSP 165
#define MC_ENGINE_IDX_DISP_LOW 176
#define MC_ENGINE_IDX_DPAUX 175
#define MC_ENGINE_IDX_ESCHED 92
#define MC_ENGINE_IDX_ESCHED__SIZE 64
#define MC_ENGINE_IDX_ESCHEDn(x) (MC_ENGINE_IDX_ESCHED + (x))
#define MC_ENGINE_IDX_FB 3
#define MC_ENGINE_IDX_FBHUB 44
#define MC_ENGINE_IDX_FIFO 4
#define MC_ENGINE_IDX_FSP 48
#define MC_ENGINE_IDX_GMMU 46
#define MC_ENGINE_IDX_GR 84
#define MC_ENGINE_IDX_GR0 MC_ENGINE_IDX_GR
#define MC_ENGINE_IDX_GR0_FECS_LOG MC_ENGINE_IDX_GR_FECS_LOG
#define MC_ENGINE_IDX_GR1 85
#define MC_ENGINE_IDX_GR1_FECS_LOG 157
#define MC_ENGINE_IDX_GR2 86
#define MC_ENGINE_IDX_GR2_FECS_LOG 158
#define MC_ENGINE_IDX_GR3 87
#define MC_ENGINE_IDX_GR3_FECS_LOG 159
#define MC_ENGINE_IDX_GR4 88
#define MC_ENGINE_IDX_GR4_FECS_LOG 160
#define MC_ENGINE_IDX_GR5 89
#define MC_ENGINE_IDX_GR5_FECS_LOG 161
#define MC_ENGINE_IDX_GR6 90
#define MC_ENGINE_IDX_GR6_FECS_LOG 162
#define MC_ENGINE_IDX_GR7 91
#define MC_ENGINE_IDX_GR7_FECS_LOG 163
#define MC_ENGINE_IDX_GR_FECS_LOG 156
#define MC_ENGINE_IDX_GRn(x) (MC_ENGINE_IDX_GR0 + (x))
#define MC_ENGINE_IDX_GRn_FECS_LOG(x) (MC_ENGINE_IDX_GR0_FECS_LOG + (x))
#define MC_ENGINE_IDX_GSP 50
#define MC_ENGINE_IDX_GSPLITE 171
#define MC_ENGINE_IDX_GSPLITE0 MC_ENGINE_IDX_GSPLITE
#define MC_ENGINE_IDX_GSPLITE1 172
#define MC_ENGINE_IDX_GSPLITE2 173
#define MC_ENGINE_IDX_GSPLITE3 174
#define MC_ENGINE_IDX_GSPLITE_MAX MC_ENGINE_IDX_GSPLITE3
#define MC_ENGINE_IDX_GSPLITEn(x) (MC_ENGINE_IDX_GSPLITE + (x))
#define MC_ENGINE_IDX_HDACODEC 45
#define MC_ENGINE_IDX_INFO_FAULT 64
#define MC_ENGINE_IDX_ISOHUB 36
#define MC_ENGINE_IDX_IS_CE(x) ((MC_ENGINE_IDX_CE(0) <= (x)) && ((x) <= MC_ENGINE_IDX_CE_MAX))
#define MC_ENGINE_IDX_LRCC 170
#define MC_ENGINE_IDX_LTC 43
#define MC_ENGINE_IDX_MAX 177
#define MC_ENGINE_IDX_MD 6
#define MC_ENGINE_IDX_MMU_ECC_ERROR 75
#define MC_ENGINE_IDX_NON_REPLAYABLE_FAULT 61
#define MC_ENGINE_IDX_NON_REPLAYABLE_FAULT_CPU 167
#define MC_ENGINE_IDX_NON_REPLAYABLE_FAULT_ERROR 63
#define MC_ENGINE_IDX_NULL 0
#define MC_ENGINE_IDX_NVDEC MC_ENGINE_IDX_BSP
#define MC_ENGINE_IDX_NVDEC0 MC_ENGINE_IDX_NVDEC
#define MC_ENGINE_IDX_NVDEC1 66
#define MC_ENGINE_IDX_NVDEC2 67
#define MC_ENGINE_IDX_NVDEC3 68
#define MC_ENGINE_IDX_NVDEC4 69
#define MC_ENGINE_IDX_NVDEC5 70
#define MC_ENGINE_IDX_NVDEC6 71
#define MC_ENGINE_IDX_NVDEC7 72
#define MC_ENGINE_IDX_NVDECn(x) (MC_ENGINE_IDX_NVDEC + (x))
#define MC_ENGINE_IDX_NVENC 38
#define MC_ENGINE_IDX_NVENC1 39
#define MC_ENGINE_IDX_NVENC2 40
#define MC_ENGINE_IDX_NVENC3 41
#define MC_ENGINE_IDX_NVENCn(x) (MC_ENGINE_IDX_NVENC + (x))
#define MC_ENGINE_IDX_NVJPEG MC_ENGINE_IDX_NVJPG
#define MC_ENGINE_IDX_NVJPEG0 MC_ENGINE_IDX_NVJPEG
#define MC_ENGINE_IDX_NVJPEG1 52
#define MC_ENGINE_IDX_NVJPEG2 53
#define MC_ENGINE_IDX_NVJPEG3 54
#define MC_ENGINE_IDX_NVJPEG4 55
#define MC_ENGINE_IDX_NVJPEG5 56
#define MC_ENGINE_IDX_NVJPEG6 57
#define MC_ENGINE_IDX_NVJPEG7 58
#define MC_ENGINE_IDX_NVJPEGn(x) (MC_ENGINE_IDX_NVJPEG + (x))
#define MC_ENGINE_IDX_NVJPG 51
#define MC_ENGINE_IDX_NVLINK 49
#define MC_ENGINE_IDX_OFA(x) (MC_ENGINE_IDX_OFA0 + (x))
#define MC_ENGINE_IDX_OFA0 81
#define MC_ENGINE_IDX_OFA1 82
#define MC_ENGINE_IDX_PERFMON 77
#define MC_ENGINE_IDX_PMGR 8
#define MC_ENGINE_IDX_PMU 14
#define MC_ENGINE_IDX_PPP 12
#define MC_ENGINE_IDX_PRIVRING 13
#define MC_ENGINE_IDX_PRIV_DOORBELL 74
#define MC_ENGINE_IDX_PXUC 168
#define MC_ENGINE_IDX_REPLAYABLE_FAULT 59
#define MC_ENGINE_IDX_REPLAYABLE_FAULT_CPU 166
#define MC_ENGINE_IDX_REPLAYABLE_FAULT_ERROR 62
#define MC_ENGINE_IDX_SEC2 47
#define MC_ENGINE_IDX_SYSLTC 169
#define MC_ENGINE_IDX_TEGRA 83
#define MC_ENGINE_IDX_TMR 1
#define MC_ENGINE_IDX_TMR_SWRL 164
#define MC_ENGINE_IDX_VGPU 37
#define MC_ENGINE_IDX_VIC 35
#define MC_ENGINE_IDX_VIDEO 5
#define MC_ENGINE_IDX_VP2 9
#define MC_ENGINE_IDX_XBAR 79
#define MC_ENGINE_IDX_ZPW 80

ABI_CHECK_SIZE_EQ(MESSAGE_QUEUE_INIT_ARGUMENTS, 32);
ABI_CHECK_FIELD(MESSAGE_QUEUE_INIT_ARGUMENTS, sharedMemPhysAddr, 0, 8);
ABI_CHECK_FIELD(MESSAGE_QUEUE_INIT_ARGUMENTS, pageTableEntryCount, 8, 4);
ABI_CHECK_FIELD(MESSAGE_QUEUE_INIT_ARGUMENTS, cmdQueueOffset, 16, 8);
ABI_CHECK_FIELD(MESSAGE_QUEUE_INIT_ARGUMENTS, statQueueOffset, 24, 8);


ABI_CHECK_SIZE_EQ(MUX_METHOD_DATA, 580);
ABI_CHECK_FIELD(MUX_METHOD_DATA, tableLen, 0, 4);
ABI_CHECK_FIELD(MUX_METHOD_DATA, acpiIdMuxModeTable, 4, 192);
ABI_CHECK_FIELD(MUX_METHOD_DATA, acpiIdMuxPartTable, 196, 192);
ABI_CHECK_FIELD(MUX_METHOD_DATA, acpiIdMuxStateTable, 388, 192);


ABI_CHECK_SIZE_EQ(MUX_METHOD_DATA_ELEMENT, 12);
ABI_CHECK_FIELD(MUX_METHOD_DATA_ELEMENT, acpiId, 0, 4);
ABI_CHECK_FIELD(MUX_METHOD_DATA_ELEMENT, mode, 4, 4);
ABI_CHECK_FIELD(MUX_METHOD_DATA_ELEMENT, status, 8, 4);


ABI_CHECK_SIZE_EQ(NV0000_ALLOC_PARAMETERS, 120);
ABI_CHECK_FIELD(NV0000_ALLOC_PARAMETERS, hClient, 0, 4);
ABI_CHECK_FIELD(NV0000_ALLOC_PARAMETERS, processID, 4, 4);
ABI_CHECK_FIELD(NV0000_ALLOC_PARAMETERS, processName, 8, 100);
ABI_CHECK_FIELD(NV0000_ALLOC_PARAMETERS, pOsPidInfo, 112, 8);


ABI_CHECK_SIZE_EQ(NV0005_ALLOC_PARAMETERS, 24);
ABI_CHECK_FIELD(NV0005_ALLOC_PARAMETERS, hParentClient, 0, 4);
ABI_CHECK_FIELD(NV0005_ALLOC_PARAMETERS, hSrcResource, 4, 4);
ABI_CHECK_FIELD(NV0005_ALLOC_PARAMETERS, hClass, 8, 4);
ABI_CHECK_FIELD(NV0005_ALLOC_PARAMETERS, notifyIndex, 12, 4);
ABI_CHECK_FIELD(NV0005_ALLOC_PARAMETERS, data, 16, 8);

#define NV0073_CTRL_CMD_DFP_ASSIGN_SOR (0x731152U)
#define NV0073_CTRL_CMD_DFP_GET_INFO (0x731140U)
#define NV0073_CTRL_CMD_DFP_SET_AUDIO_ENABLE (0x731150U)
#define NV0073_CTRL_CMD_DFP_SET_ELD_AUDIO_CAPS (0x731144U)
#define NV0073_CTRL_CMD_DP_AUXCH_CTRL (0x731341U)
#define NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES (0x731377U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES_PARAMS, 44);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES_PARAMS, linkRateTbl, 8, 16);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES_PARAMS, linkBwTbl, 24, 16);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_INDEXED_LINK_RATES_PARAMS, linkBwCount, 40, 1);

#define NV0073_CTRL_CMD_DP_CONFIG_STREAM (0x731362U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, 84);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, head, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, sorIndex, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, dpLink, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, bEnableOverride, 16, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, bMST, 17, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, singleHeadMultistreamMode, 20, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, hBlankSym, 24, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, vBlankSym, 28, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, colorFormat, 32, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, bEnableTwoHeadOneOr, 36, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, MST, 40, 28);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_CONFIG_STREAM_PARAMS, SST, 68, 16);

#define NV0073_CTRL_CMD_DP_CTRL (0x731343U)
#define NV0073_CTRL_CMD_DP_GET_CAPS (0x731369U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, 64);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, sorIndex, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, maxLinkRate, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, dpVersionsSupported, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, UHBRSupportedByGpu, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, minPClkForCompressed, 20, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bIsMultistreamSupported, 24, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bIsSCEnabled, 25, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bHasIncreasedWatermarkLimits, 26, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bIsPC2Disabled, 27, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, isSingleHeadMSTSupported, 28, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bFECSupported, 29, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bIsTrainPhyRepeater, 30, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bOverrideLinkBw, 31, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bUseRgFlushSequence, 32, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, bSupportDPDownSpread, 33, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_GET_CAPS_PARAMS, DSC, 36, 28);

#define NV0073_CTRL_CMD_DP_SET_AUDIO_MUTESTREAM (0x731359U)
#define NV0073_CTRL_CMD_DP_SET_LANE_DATA (0x731346U)
#define NV0073_CTRL_CMD_DP_SET_MANUAL_DISPLAYPORT (0x731365U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DP_SET_MANUAL_DISPLAYPORT_PARAMS, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_SET_MANUAL_DISPLAYPORT_PARAMS, subDeviceInstance, 0, 4);

#define NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID (0x73135bU)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, 24);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, preferredDisplayId, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, force, 12, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, useBFM, 13, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, displayIdAssigned, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_ALLOCATE_DISPLAYID_PARAMS, allDisplayMask, 20, 4);

#define NV0073_CTRL_CMD_DP_TOPOLOGY_FREE_DISPLAYID (0x73135cU)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DP_TOPOLOGY_FREE_DISPLAYID_PARAMS, 8);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_FREE_DISPLAYID_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DP_TOPOLOGY_FREE_DISPLAYID_PARAMS, displayId, 4, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_DSC_CAP_PARAMS, 28);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, bDscSupported, 0, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, encoderColorFormatMask, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, lineBufferSizeKB, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, rateBufferSizeKB, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, bitsPerPixelPrecision, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, maxNumHztSlices, 20, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_DSC_CAP_PARAMS, lineBufferBitDepth, 24, 4);

#define NV0073_CTRL_CMD_SPECIFIC_GET_ALL_HEAD_MASK (0x730287U)
#define NV0073_CTRL_CMD_SPECIFIC_GET_BACKLIGHT_BRIGHTNESS (0x730291U)
#define NV0073_CTRL_CMD_SPECIFIC_GET_CONNECTOR_DATA (0x730250U)
#define NV0073_CTRL_CMD_SPECIFIC_GET_EDID_V2 (0x730245U)
#define NV0073_CTRL_CMD_SPECIFIC_OR_GET_INFO (0x73028bU)
#define NV0073_CTRL_CMD_SPECIFIC_SET_BACKLIGHT_BRIGHTNESS (0x730292U)
#define NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_AUDIO_MUTESTREAM (0x730275U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_AUDIO_MUTESTREAM_PARAMS, 12);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_AUDIO_MUTESTREAM_PARAMS, subDeviceInstance, 0, 1);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_AUDIO_MUTESTREAM_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_AUDIO_MUTESTREAM_PARAMS, mute, 8, 1);

#define NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_ENABLE (0x730273U)
#define NV0073_CTRL_CMD_SPECIFIC_SET_HDMI_SINK_CAPS (0x730293U)
#define NV0073_CTRL_CMD_SPECIFIC_SET_OD_PACKET (0x730288U)
#define NV0073_CTRL_CMD_SYSTEM_GET_ACTIVE (0x73010cU)
#define NV0073_CTRL_CMD_SYSTEM_GET_CONNECT_STATE (0x730108U)
#define NV0073_CTRL_CMD_SYSTEM_GET_NUM_HEADS (0x730102U)
#define NV0073_CTRL_CMD_SYSTEM_GET_SUPPORTED (0x730107U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_DFP_ASSIGN_SOR_INFO, 8);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_INFO, displayMask, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_INFO, sorType, 4, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, 80);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, sorExcludeMask, 8, 1);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, slaveDisplayId, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, forceSublinkConfig, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, bIs2Head1Or, 20, 1);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, sorAssignList, 24, 16);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, sorAssignListWithTag, 40, 32);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, reservedSorMask, 72, 1);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_ASSIGN_SOR_PARAMS, flags, 76, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_DFP_GET_INFO_PARAMS, 16);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_GET_INFO_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_GET_INFO_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_GET_INFO_PARAMS, flags, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_GET_INFO_PARAMS, UHBRSupportedByDfp, 12, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, 120);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, numELDSize, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, bufferELD, 12, 96);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, maxFreqSupported, 108, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, ctrl, 112, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DFP_SET_ELD_AUDIO_CAP_PARAMS, deviceEntry, 116, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, 48);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, bAddrOnly, 8, 1);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, cmd, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, addr, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, data, 20, 16);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, size, 36, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, replyType, 40, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_AUXCH_CTRL_PARAMS, retryTimeMs, 44, 4);

#define NV0073_CTRL_DP_CMD_BANDWIDTH_TEST 29:29
#define NV0073_CTRL_DP_CMD_BANDWIDTH_TEST_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_BANDWIDTH_TEST_YES (0x00000001U)
#define NV0073_CTRL_DP_CMD_DISABLE_DOWNSPREAD 2:2
#define NV0073_CTRL_DP_CMD_DISABLE_DOWNSPREAD_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_DISABLE_DOWNSPREAD_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_DISABLE_LINK_CONFIG 31:31
#define NV0073_CTRL_DP_CMD_DISABLE_LINK_CONFIG_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_DISABLE_LINK_CONFIG_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_ENABLE_FEC 15:15
#define NV0073_CTRL_DP_CMD_ENABLE_FEC_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_ENABLE_FEC_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE 3:0
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_DRIVER_ENABLE_BEGIN (0x00000003U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_DRIVER_ENABLE_CHALLENGE (0x00000004U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_DRIVER_ENABLE_CHECK (0x00000005U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_GET_PUBLIC_INFO (0x00000008U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_INIT_PUBLIC_INFO (0x00000007U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_MONITOR_ENABLE_BEGIN (0x00000000U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_MONITOR_ENABLE_CHALLENGE (0x00000001U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_MONITOR_ENABLE_CHECK (0x00000002U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_RESET_MONITOR (0x00000006U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_CMD_STAGE_STATUS_CHECK (0x00000009U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_STATUS_DEVICE_ERROR (0x80000004U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_STATUS_OK (0x00000000U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_STATUS_PENDING (0x80000001U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_STATUS_READ_ERROR (0x80000002U)
#define NV0073_CTRL_DP_CMD_ENABLE_VRR_STATUS_WRITE_ERROR (0x80000003U)
#define NV0073_CTRL_DP_CMD_FAKE_LINK_TRAINING 12:11
#define NV0073_CTRL_DP_CMD_FAKE_LINK_TRAINING_DONOT_TOGGLE_TRANSMISSION (0x00000001U)
#define NV0073_CTRL_DP_CMD_FAKE_LINK_TRAINING_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_FAKE_LINK_TRAINING_TOGGLE_TRANSMISSION_ON (0x00000002U)
#define NV0073_CTRL_DP_CMD_FALLBACK_CONFIG 14:14
#define NV0073_CTRL_DP_CMD_FALLBACK_CONFIG_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_FALLBACK_CONFIG_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_FAST_LINK_TRAINING 5:5
#define NV0073_CTRL_DP_CMD_FAST_LINK_TRAINING_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_FAST_LINK_TRAINING_YES (0x00000001U)
#define NV0073_CTRL_DP_CMD_LINK_CONFIG_CHECK_DISABLE 30:30
#define NV0073_CTRL_DP_CMD_LINK_CONFIG_CHECK_DISABLE_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_LINK_CONFIG_CHECK_DISABLE_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_NO_LINK_TRAINING 6:6
#define NV0073_CTRL_DP_CMD_NO_LINK_TRAINING_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_NO_LINK_TRAINING_YES (0x00000001U)
#define NV0073_CTRL_DP_CMD_POST_LT_ADJ_REQ_GRANTED 10:10
#define NV0073_CTRL_DP_CMD_POST_LT_ADJ_REQ_GRANTED_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_POST_LT_ADJ_REQ_GRANTED_YES (0x00000001U)
#define NV0073_CTRL_DP_CMD_SET_ENHANCED_FRAMING 7:7
#define NV0073_CTRL_DP_CMD_SET_ENHANCED_FRAMING_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_SET_ENHANCED_FRAMING_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_SET_FORMAT_MODE 4:4
#define NV0073_CTRL_DP_CMD_SET_FORMAT_MODE_MULTI_STREAM (0x00000001U)
#define NV0073_CTRL_DP_CMD_SET_FORMAT_MODE_SINGLE_STREAM (0x00000000U)
#define NV0073_CTRL_DP_CMD_SET_LANE_COUNT 0:0
#define NV0073_CTRL_DP_CMD_SET_LANE_COUNT_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_SET_LANE_COUNT_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_SET_LINK_BW 1:1
#define NV0073_CTRL_DP_CMD_SET_LINK_BW_FALSE (0x00000000U)
#define NV0073_CTRL_DP_CMD_SET_LINK_BW_TRUE (0x00000001U)
#define NV0073_CTRL_DP_CMD_SKIP_HW_PROGRAMMING 9:9
#define NV0073_CTRL_DP_CMD_SKIP_HW_PROGRAMMING_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_SKIP_HW_PROGRAMMING_YES (0x00000001U)
#define NV0073_CTRL_DP_CMD_TRAIN_PHY_REPEATER 13:13
#define NV0073_CTRL_DP_CMD_TRAIN_PHY_REPEATER_NO (0x00000000U)
#define NV0073_CTRL_DP_CMD_TRAIN_PHY_REPEATER_YES (0x00000001U)
#define NV0073_CTRL_DP_CMD_UNUSED 3:3
#define NV0073_CTRL_DP_CMD_USE_DOWNSPREAD_SETTING 8:8
#define NV0073_CTRL_DP_CMD_USE_DOWNSPREAD_SETTING_DEFAULT (0x00000000U)
#define NV0073_CTRL_DP_CMD_USE_DOWNSPREAD_SETTING_FORCE (0x00000001U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_DP_CTRL_PARAMS, 28);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, cmd, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, data, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, err, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, retryTimeMs, 20, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_CTRL_PARAMS, eightLaneDpcdBaseAddr, 24, 4);

#define NV0073_CTRL_DP_DATA_SET_ENHANCED_FRAMING 18:18
#define NV0073_CTRL_DP_DATA_SET_ENHANCED_FRAMING_NO (0x00000000U)
#define NV0073_CTRL_DP_DATA_SET_ENHANCED_FRAMING_YES (0x00000001U)
#define NV0073_CTRL_DP_DATA_SET_LANE_COUNT 4:0
#define NV0073_CTRL_DP_DATA_SET_LANE_COUNT_0 (0x00000000U)
#define NV0073_CTRL_DP_DATA_SET_LANE_COUNT_1 (0x00000001U)
#define NV0073_CTRL_DP_DATA_SET_LANE_COUNT_2 (0x00000002U)
#define NV0073_CTRL_DP_DATA_SET_LANE_COUNT_4 (0x00000004U)
#define NV0073_CTRL_DP_DATA_SET_LANE_COUNT_8 (0x00000008U)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW 15:8
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_1_62GBPS (0x00000006U)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_2_16GBPS (0x00000008U)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_2_43GBPS (0x00000009U)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_2_70GBPS (0x0000000AU)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_3_24GBPS (0x0000000CU)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_4_32GBPS (0x00000010U)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_5_40GBPS (0x00000014U)
#define NV0073_CTRL_DP_DATA_SET_LINK_BW_8_10GBPS (0x0000001EU)
#define NV0073_CTRL_DP_DATA_TARGET 22:19
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_0 (0x00000001U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_1 (0x00000002U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_2 (0x00000003U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_3 (0x00000004U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_4 (0x00000005U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_5 (0x00000006U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_6 (0x00000007U)
#define NV0073_CTRL_DP_DATA_TARGET_PHY_REPEATER_7 (0x00000008U)
#define NV0073_CTRL_DP_DATA_TARGET_SINK (0x00000000U)
#define NV0073_CTRL_DP_LANE_DATA_DRIVECURRENT 3:2
#define NV0073_CTRL_DP_LANE_DATA_DRIVECURRENT_LEVEL0 (0x00000000U)
#define NV0073_CTRL_DP_LANE_DATA_DRIVECURRENT_LEVEL1 (0x00000001U)
#define NV0073_CTRL_DP_LANE_DATA_DRIVECURRENT_LEVEL2 (0x00000002U)
#define NV0073_CTRL_DP_LANE_DATA_DRIVECURRENT_LEVEL3 (0x00000003U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_DP_LANE_DATA_PARAMS, 44);
ABI_CHECK_FIELD(NV0073_CTRL_DP_LANE_DATA_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_LANE_DATA_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_LANE_DATA_PARAMS, numLanes, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_LANE_DATA_PARAMS, data, 12, 32);

#define NV0073_CTRL_DP_LANE_DATA_PREEMPHASIS 1:0
#define NV0073_CTRL_DP_LANE_DATA_PREEMPHASIS_LEVEL1 (0x00000001U)
#define NV0073_CTRL_DP_LANE_DATA_PREEMPHASIS_LEVEL2 (0x00000002U)
#define NV0073_CTRL_DP_LANE_DATA_PREEMPHASIS_LEVEL3 (0x00000003U)
#define NV0073_CTRL_DP_LANE_DATA_PREEMPHASIS_NONE (0x00000000U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_DP_SET_AUDIO_MUTESTREAM_PARAMS, 12);
ABI_CHECK_FIELD(NV0073_CTRL_DP_SET_AUDIO_MUTESTREAM_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_SET_AUDIO_MUTESTREAM_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_DP_SET_AUDIO_MUTESTREAM_PARAMS, mute, 8, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_BACKLIGHT_BRIGHTNESS_PARAMS, 16);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_BACKLIGHT_BRIGHTNESS_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_BACKLIGHT_BRIGHTNESS_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_BACKLIGHT_BRIGHTNESS_PARAMS, brightness, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_BACKLIGHT_BRIGHTNESS_PARAMS, bUncalibrated, 12, 1);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_BACKLIGHT_BRIGHTNESS_PARAMS, brightnessType, 13, 1);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_GET_ALL_HEAD_MASK_PARAMS, 8);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_ALL_HEAD_MASK_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_ALL_HEAD_MASK_PARAMS, headMask, 4, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, 72);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, flags, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, DDCPartners, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, count, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, data, 20, 48);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_CONNECTOR_DATA_PARAMS, platform, 68, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_GET_EDID_V2_PARAMS, 2064);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_EDID_V2_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_EDID_V2_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_EDID_V2_PARAMS, bufferSize, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_EDID_V2_PARAMS, flags, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_GET_EDID_V2_PARAMS, edidBuffer, 16, 2048);

#define NV0073_CTRL_SPECIFIC_OR_DITHER_ALGO_DYNAMIC_2X2 (0x00000002U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_ALGO_DYNAMIC_ERR_ACC (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_ALGO_STATIC_2X2 (0x00000003U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_ALGO_STATIC_ERR_ACC (0x00000001U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_ALGO_TEMPORAL (0x00000004U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_ALGO_UNKNOWN (0xFFFFFFFFU)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_TYPE_10_BITS (0x00000002U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_TYPE_6_BITS (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_TYPE_8_BITS (0x00000001U)
#define NV0073_CTRL_SPECIFIC_OR_DITHER_TYPE_OFF (0x00000003U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, 56);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, index, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, type, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, protocol, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, ditherType, 20, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, ditherAlgo, 24, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, location, 28, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, rootPortId, 32, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, dcbIndex, 36, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, vbiosAddress, 40, 8);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, bIsLitByVbios, 48, 1);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS, bIsDispDynamic, 49, 1);

#define NV0073_CTRL_SPECIFIC_OR_GET_INFO_PARAMS_MESSAGE_ID (0x8BU)
#define NV0073_CTRL_SPECIFIC_OR_LOCATION_BOARD (0x00000001U)
#define NV0073_CTRL_SPECIFIC_OR_LOCATION_CHIP (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_DAC_RGB_CRT (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_DSI (0x00000011U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_PIOR_EXT_TMDS_ENC (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_DP_A (0x00000008U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_DP_B (0x00000009U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_DSI (0x00000010U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_DUAL_TMDS (0x00000005U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_LVDS_CUSTOM (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_SINGLE_TMDS_A (0x00000001U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_SOR_SINGLE_TMDS_B (0x00000002U)
#define NV0073_CTRL_SPECIFIC_OR_PROTOCOL_UNKNOWN (0xFFFFFFFFU)
#define NV0073_CTRL_SPECIFIC_OR_TYPE_DAC (0x00000001U)
#define NV0073_CTRL_SPECIFIC_OR_TYPE_DSI (0x00000005U)
#define NV0073_CTRL_SPECIFIC_OR_TYPE_NONE (0x00000000U)
#define NV0073_CTRL_SPECIFIC_OR_TYPE_PIOR (0x00000003U)
#define NV0073_CTRL_SPECIFIC_OR_TYPE_SOR (0x00000002U)

ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_SET_HDMI_ENABLE_PARAMS, 12);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_HDMI_ENABLE_PARAMS, subDeviceInstance, 0, 1);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_HDMI_ENABLE_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_HDMI_ENABLE_PARAMS, enable, 8, 1);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_SET_HDMI_SINK_CAPS_PARAMS, 12);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_HDMI_SINK_CAPS_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_HDMI_SINK_CAPS_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_HDMI_SINK_CAPS_PARAMS, caps, 8, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, 60);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, displayId, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, transmitControl, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, packetSize, 12, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, targetHead, 16, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, bUsePsrHeadforSdp, 20, 1);
ABI_CHECK_FIELD(NV0073_CTRL_SPECIFIC_SET_OD_PACKET_PARAMS, aPacket, 21, 36);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SYSTEM_GET_ACTIVE_PARAMS, 16);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_ACTIVE_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_ACTIVE_PARAMS, head, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_ACTIVE_PARAMS, flags, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_ACTIVE_PARAMS, displayId, 12, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SYSTEM_GET_CONNECT_STATE_PARAMS, 16);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_CONNECT_STATE_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_CONNECT_STATE_PARAMS, flags, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_CONNECT_STATE_PARAMS, displayMask, 8, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_CONNECT_STATE_PARAMS, retryTimeMs, 12, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SYSTEM_GET_NUM_HEADS_PARAMS, 12);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_NUM_HEADS_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_NUM_HEADS_PARAMS, flags, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_NUM_HEADS_PARAMS, numHeads, 8, 4);


ABI_CHECK_SIZE_EQ(NV0073_CTRL_SYSTEM_GET_SUPPORTED_PARAMS, 12);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_SUPPORTED_PARAMS, subDeviceInstance, 0, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_SUPPORTED_PARAMS, displayMask, 4, 4);
ABI_CHECK_FIELD(NV0073_CTRL_SYSTEM_GET_SUPPORTED_PARAMS, displayMaskDDC, 8, 4);


ABI_CHECK_SIZE_EQ(NV0080_ALLOC_PARAMETERS, 56);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, deviceId, 0, 4);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, hClientShare, 4, 4);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, hTargetClient, 8, 4);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, hTargetDevice, 12, 4);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, flags, 16, 4);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, vaSpaceSize, 24, 8);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, vaStartInternal, 32, 8);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, vaLimitInternal, 40, 8);
ABI_CHECK_FIELD(NV0080_ALLOC_PARAMETERS, vaMode, 48, 4);

#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID 4:0
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_CAPTURE (0x00000004)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_COMPUTE_PREEMPT (0x0000000a)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_COUNT (0x0000001a)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_DISPLAY (0x00000005)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_ENCRYPTION (0x00000006)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS (0x00000000)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_ATTRIBUTE_CB (0x00000013)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_BETACB (0x0000000e)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_BUNDLE_CB (0x00000011)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_FECS_EVENT (0x00000017)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_GFXP_CTRL_BLK (0x00000016)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_GFXP_POOL (0x00000015)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PAGEPOOL (0x0000000d)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PAGEPOOL_GLOBAL (0x00000012)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PATCH (0x00000010)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PM (0x00000009)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PREEMPT (0x0000000b)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PRIV_ACCESS_MAP (0x00000018)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_RTV (0x0000000f)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_RTV_CB_GLOBAL (0x00000014)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_SETUP (0x00000019)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_SPILL (0x0000000c)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_ZCULL (0x00000008)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_MPEG (0x00000003)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_POSTPROCESS (0x00000007)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_VIDEO (0x00000002)
#define NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_VLD (0x00000001)

ABI_CHECK_SIZE_EQ(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, 80);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, totalVFs, 0, 4);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, firstVfOffset, 4, 4);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, vfFeatureMask, 8, 4);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, FirstVFBar0Address, 16, 8);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, FirstVFBar1Address, 24, 8);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, FirstVFBar2Address, 32, 8);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bar0Size, 40, 8);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bar1Size, 48, 8);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bar2Size, 56, 8);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, b64bitBar0, 64, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, b64bitBar1, 65, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, b64bitBar2, 66, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bSriovEnabled, 67, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bSriovHeavyEnabled, 68, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bEmulateVFBar0TlbInvalidationRegister, 69, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bClientRmAllocatedCtxBuffer, 70, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bNonPowerOf2ChannelCountSupported, 71, 1);
ABI_CHECK_FIELD(NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS, bVfResizableBAR1Supported, 72, 1);

#define NV01_DEVICE_0 (0x80U)
#define NV01_EVENT_CLIENT_RM (0x04000000)
#define NV01_EVENT_KERNEL_CALLBACK_EX (0x0000007E)
#define NV01_MEMORY_LIST_FBMEM (0x00000082)
#define NV01_MEMORY_LIST_SYSTEM (0x00000081)
#define NV01_ROOT (0x0U)
#define NV04_DISPLAY_COMMON (0x00000073)

ABI_CHECK_SIZE_EQ(NV2080_ALLOC_PARAMETERS, 4);
ABI_CHECK_FIELD(NV2080_ALLOC_PARAMETERS, subDeviceId, 0, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, 48);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, BoardID, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, chipSKU, 4, 9);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, chipSKUMod, 13, 5);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, skuConfigVersion, 20, 4);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, project, 24, 5);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, projectSKU, 29, 5);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, CDP, 34, 6);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, projectSKUMod, 40, 2);
ABI_CHECK_FIELD(NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS, businessCycle, 44, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS, 4);
ABI_CHECK_FIELD(NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS, size, 0, 4);

#define NV2080_CTRL_CMD_CE_GET_FAULT_METHOD_BUFFER_SIZE (0x20802a08)
#define NV2080_CTRL_CMD_EVENT_SET_NOTIFICATION (0x20800301)

ABI_CHECK_SIZE_EQ(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, 48);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, base, 0, 8);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, limit, 8, 8);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, reserved, 16, 8);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, performance, 24, 4);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, supportCompressed, 28, 1);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, supportISO, 29, 1);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, bProtected, 30, 1);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO, blackList, 31, 17);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS, 776);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS, numFBRegions, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS, fbRegion, 8, 768);

#define NV2080_CTRL_CMD_FIFO_GET_DEVICE_INFO_TABLE (0x20801112)
#define NV2080_CTRL_CMD_GPU_GET_CONSTRUCTED_FALCON_INFO (0x208001b0)
#define NV2080_CTRL_CMD_GPU_PROMOTE_CTX (0x2080012bU)
#define NV2080_CTRL_CMD_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER (0x20800a58)
#define NV2080_CTRL_CMD_INTERNAL_DISPLAY_GET_STATIC_INFO (0x20800a01)
#define NV2080_CTRL_CMD_INTERNAL_DISPLAY_WRITE_INST_MEM (0x20800a49)
#define NV2080_CTRL_CMD_INTERNAL_INIT_BRIGHTC_STATE_LOAD (0x20800ac6)
#define NV2080_CTRL_CMD_INTERNAL_INTR_GET_KERNEL_TABLE (0x20800a5c)
#define NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_CONTEXT_BUFFERS_INFO (0x20800a32)

ABI_CHECK_SIZE_EQ(NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS, 20);
ABI_CHECK_FIELD(NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS, event, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS, action, 4, 4);
ABI_CHECK_FIELD(NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS, bNotifyState, 8, 1);
ABI_CHECK_FIELD(NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS, info32, 12, 4);
ABI_CHECK_FIELD(NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS, info16, 16, 2);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_FIFO_DEVICE_ENTRY, 100);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_DEVICE_ENTRY, engineData, 0, 64);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_DEVICE_ENTRY, pbdmaIds, 64, 8);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_DEVICE_ENTRY, pbdmaFaultIds, 72, 8);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_DEVICE_ENTRY, numPbdmas, 80, 4);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_DEVICE_ENTRY, engineName, 84, 16);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS, 3212);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS, baseIndex, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS, numEntries, 4, 4);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS, bMore, 8, 1);
ABI_CHECK_FIELD(NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS, entries, 12, 3200);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS, 1284);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS, numConstructedFalcons, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS, constructedFalconsTable, 4, 1280);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS, gpcMask, 0, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS, gpcId, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS, tpcMask, 4, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS, gpcId, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS, zcullMask, 4, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_GET_GID_INFO_PARAMS, 268);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_GID_INFO_PARAMS, index, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_GID_INFO_PARAMS, flags, 4, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_GID_INFO_PARAMS, length, 8, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_GET_GID_INFO_PARAMS, data, 12, 256);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, 32);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, gpuPhysAddr, 0, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, gpuVirtAddr, 8, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, size, 16, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, physAttr, 24, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, bufferId, 28, 2);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, bInitialize, 30, 1);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY, bNonmapped, 31, 1);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, 560);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, engineType, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, hClient, 4, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, ChID, 8, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, hChanClient, 12, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, hObject, 16, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, hVirtMemory, 20, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, virtAddress, 24, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, size, 32, 8);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, entryCount, 40, 4);
ABI_CHECK_FIELD(NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS, promoteEntry, 48, 512);

#define NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_0 (0x00000000U)
#define NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_3 (0x00000003U)

ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, 56);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, addressSpace, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, physicalAddr, 8, 8);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, limit, 16, 8);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, cacheSnoop, 24, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, hclass, 28, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, channelInstance, 32, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, valid, 36, 1);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, pbTargetAperture, 40, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, channelPBSize, 44, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS, subDeviceId, 48, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, 36);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, feHwSysCap, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, windowPresentMask, 4, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, bFbRemapperEnabled, 8, 1);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, numHeads, 12, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, i2cPort, 16, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, internalDispActiveMask, 20, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, embeddedDisplayPortMask, 24, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, bExternalMuxSupported, 28, 1);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, bInternalMuxSupported, 29, 1);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS, numDispChannels, 32, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS, 24);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS, instMemPhysAddr, 0, 8);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS, instMemSize, 8, 8);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS, instMemAddrSpace, 16, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS, instMemCpuCacheAttr, 20, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO, 8);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO, size, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO, alignment, 4, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS, 4104);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS, status, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS, backLightDataSize, 4, 2);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS, backLightData, 6, 4096);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY, 16);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY, engineIdx, 0, 2);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY, pmcIntrMask, 4, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY, vectorStall, 8, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY, vectorNonStall, 12, 4);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS, 2068);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS, tableLen, 0, 4);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS, table, 4, 2048);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS, subtreeMap, 2052, 14);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_STATIC_GR_CONTEXT_BUFFERS_INFO, 208);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_STATIC_GR_CONTEXT_BUFFERS_INFO, engine, 0, 208);


ABI_CHECK_SIZE_EQ(NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS, 1664);
ABI_CHECK_FIELD(NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS, engineContextBuffersInfo, 0, 1664);

#define NV2080_ENGINE_TYPE_ALLENGINES (0xffffffff)
#define NV2080_ENGINE_TYPE_BSP (0x00000013)
#define NV2080_ENGINE_TYPE_CIPHER (0x00000023)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY(i) (NV2080_ENGINE_TYPE_COMP_DECOMP_COPY0 + (i))
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY0 (0x00000040)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY1 (0x00000041)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY10 (0x0000004a)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY11 (0x0000004b)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY12 (0x0000004c)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY13 (0x0000004d)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY14 (0x0000004e)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY15 (0x0000004f)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY16 (0x00000050)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY17 (0x00000051)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY18 (0x00000052)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY19 (0x00000053)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY2 (0x00000042)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY3 (0x00000043)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY4 (0x00000044)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY5 (0x00000045)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY6 (0x00000046)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY7 (0x00000047)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY8 (0x00000048)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY9 (0x00000049)
#define NV2080_ENGINE_TYPE_COMP_DECOMP_COPY_IDX(i) ((i) - NV2080_ENGINE_TYPE_COMP_DECOMP_COPY0)
#define NV2080_ENGINE_TYPE_COPY(i) (((i) < 10) ? (NV2080_ENGINE_TYPE_COPY0 + (i)) : (NV2080_ENGINE_TYPE_COPY10 + (i) - 10))
#define NV2080_ENGINE_TYPE_COPY0 (0x00000009)
#define NV2080_ENGINE_TYPE_COPY1 (0x0000000a)
#define NV2080_ENGINE_TYPE_COPY10 (0x00000034)
#define NV2080_ENGINE_TYPE_COPY11 (0x00000035)
#define NV2080_ENGINE_TYPE_COPY12 (0x00000036)
#define NV2080_ENGINE_TYPE_COPY13 (0x00000037)
#define NV2080_ENGINE_TYPE_COPY14 (0x00000038)
#define NV2080_ENGINE_TYPE_COPY15 (0x00000039)
#define NV2080_ENGINE_TYPE_COPY16 (0x0000003a)
#define NV2080_ENGINE_TYPE_COPY17 (0x0000003b)
#define NV2080_ENGINE_TYPE_COPY18 (0x0000003c)
#define NV2080_ENGINE_TYPE_COPY19 (0x0000003d)
#define NV2080_ENGINE_TYPE_COPY2 (0x0000000b)
#define NV2080_ENGINE_TYPE_COPY3 (0x0000000c)
#define NV2080_ENGINE_TYPE_COPY4 (0x0000000d)
#define NV2080_ENGINE_TYPE_COPY5 (0x0000000e)
#define NV2080_ENGINE_TYPE_COPY6 (0x0000000f)
#define NV2080_ENGINE_TYPE_COPY7 (0x00000010)
#define NV2080_ENGINE_TYPE_COPY8 (0x00000011)
#define NV2080_ENGINE_TYPE_COPY9 (0x00000012)
#define NV2080_ENGINE_TYPE_COPY_IDX(i) (((i) <= NV2080_ENGINE_TYPE_COPY9) ? ((i) - NV2080_ENGINE_TYPE_COPY0) : ((i) - NV2080_ENGINE_TYPE_COPY10 + 10))
#define NV2080_ENGINE_TYPE_COPY_SIZE 64
#define NV2080_ENGINE_TYPE_COPY_SIZE_v1A_0D (10)
#define NV2080_ENGINE_TYPE_COPY_SIZE_v22_00 (10)
#define NV2080_ENGINE_TYPE_COPY_SIZE_v24_09 (64)
#define NV2080_ENGINE_TYPE_DPU (0x00000028)
#define NV2080_ENGINE_TYPE_FBFLCN (0x0000002a)
#define NV2080_ENGINE_TYPE_GR(i) (NV2080_ENGINE_TYPE_GR0 + (i))
#define NV2080_ENGINE_TYPE_GR0 NV2080_ENGINE_TYPE_GRAPHICS
#define NV2080_ENGINE_TYPE_GR1 (0x00000002)
#define NV2080_ENGINE_TYPE_GR2 (0x00000003)
#define NV2080_ENGINE_TYPE_GR3 (0x00000004)
#define NV2080_ENGINE_TYPE_GR4 (0x00000005)
#define NV2080_ENGINE_TYPE_GR5 (0x00000006)
#define NV2080_ENGINE_TYPE_GR6 (0x00000007)
#define NV2080_ENGINE_TYPE_GR7 (0x00000008)
#define NV2080_ENGINE_TYPE_GRAPHICS (0x00000001)
#define NV2080_ENGINE_TYPE_GR_IDX(i) ((i) - NV2080_ENGINE_TYPE_GR0)
#define NV2080_ENGINE_TYPE_GR_SIZE 8
#define NV2080_ENGINE_TYPE_HOST (0x00000027)
#define NV2080_ENGINE_TYPE_IS_COMP_DECOMP_COPY(i) (((i) >= NV2080_ENGINE_TYPE_COMP_DECOMP_COPY0) && ((i) <= NV2080_ENGINE_TYPE_COMP_DECOMP_COPY19))
#define NV2080_ENGINE_TYPE_IS_COPY(i) ((((i) >= NV2080_ENGINE_TYPE_COPY0) && ((i) <= NV2080_ENGINE_TYPE_COPY9)) || (((i) >= NV2080_ENGINE_TYPE_COPY10) && ((i) <= NV2080_ENGINE_TYPE_COPY19)))
#define NV2080_ENGINE_TYPE_IS_GR(i) (((i) >= NV2080_ENGINE_TYPE_GR0) && ((i) < NV2080_ENGINE_TYPE_GR(NV2080_ENGINE_TYPE_GR_SIZE)))
#define NV2080_ENGINE_TYPE_IS_NVDEC(i) (((i) >= NV2080_ENGINE_TYPE_NVDEC0) && ((i) < NV2080_ENGINE_TYPE_NVDEC(NV2080_ENGINE_TYPE_NVDEC_SIZE)))
#define NV2080_ENGINE_TYPE_IS_NVENC(i) ((((i) >= NV2080_ENGINE_TYPE_NVENC0) && ((i) <= NV2080_ENGINE_TYPE_NVENC2)) || (((i) == NV2080_ENGINE_TYPE_NVENC3)))
#define NV2080_ENGINE_TYPE_IS_NVJPEG(i) (((i) >= NV2080_ENGINE_TYPE_NVJPEG0) && ((i) < NV2080_ENGINE_TYPE_NVJPEG(NV2080_ENGINE_TYPE_NVJPEG_SIZE)))
#define NV2080_ENGINE_TYPE_IS_OFA(i) (((i) == NV2080_ENGINE_TYPE_OFA0) || ((i) == NV2080_ENGINE_TYPE_OFA1))
#define NV2080_ENGINE_TYPE_IS_VALID(i) (((i) > (NV2080_ENGINE_TYPE_NULL)) && ((i) < (NV2080_ENGINE_TYPE_LAST)))
#define NV2080_ENGINE_TYPE_LAST (0x00000054)
#define NV2080_ENGINE_TYPE_LAST_v18_01 (0x0000002a)
#define NV2080_ENGINE_TYPE_LAST_v1A_00 (0x2a)
#define NV2080_ENGINE_TYPE_LAST_v1C_09 (0x00000034)
#define NV2080_ENGINE_TYPE_LAST_v27_02 (0x00000054)
#define NV2080_ENGINE_TYPE_ME (0x0000001f)
#define NV2080_ENGINE_TYPE_MP (0x00000025)
#define NV2080_ENGINE_TYPE_MPEG (0x00000021)
#define NV2080_ENGINE_TYPE_MSENC (0x0000001b)
#define NV2080_ENGINE_TYPE_NULL (0x00000000)
#define NV2080_ENGINE_TYPE_NVDEC(i) (NV2080_ENGINE_TYPE_NVDEC0+(i))
#define NV2080_ENGINE_TYPE_NVDEC0 NV2080_ENGINE_TYPE_BSP
#define NV2080_ENGINE_TYPE_NVDEC1 (0x00000014)
#define NV2080_ENGINE_TYPE_NVDEC2 (0x00000015)
#define NV2080_ENGINE_TYPE_NVDEC3 (0x00000016)
#define NV2080_ENGINE_TYPE_NVDEC4 (0x00000017)
#define NV2080_ENGINE_TYPE_NVDEC5 (0x00000018)
#define NV2080_ENGINE_TYPE_NVDEC6 (0x00000019)
#define NV2080_ENGINE_TYPE_NVDEC7 (0x0000001a)
#define NV2080_ENGINE_TYPE_NVDEC_IDX(i) ((i) - NV2080_ENGINE_TYPE_NVDEC0)
#define NV2080_ENGINE_TYPE_NVDEC_SIZE 8
#define NV2080_ENGINE_TYPE_NVENC(i) (((i) < 3) ? (NV2080_ENGINE_TYPE_NVENC0 + (i)) : (NV2080_ENGINE_TYPE_NVENC3 + (i) - 3))
#define NV2080_ENGINE_TYPE_NVENC0 NV2080_ENGINE_TYPE_MSENC
#define NV2080_ENGINE_TYPE_NVENC1 (0x0000001c)
#define NV2080_ENGINE_TYPE_NVENC2 (0x0000001d)
#define NV2080_ENGINE_TYPE_NVENC3 (0x0000003f)
#define NV2080_ENGINE_TYPE_NVENC_IDX(i) (((i) <= NV2080_ENGINE_TYPE_NVENC2) ? ((i)-NV2080_ENGINE_TYPE_NVENC0) : ((i)-NV2080_ENGINE_TYPE_NVENC3 + 3))
#define NV2080_ENGINE_TYPE_NVENC_SIZE 4
#define NV2080_ENGINE_TYPE_NVJPEG(i) (NV2080_ENGINE_TYPE_NVJPEG0+(i))
#define NV2080_ENGINE_TYPE_NVJPEG0 NV2080_ENGINE_TYPE_NVJPG
#define NV2080_ENGINE_TYPE_NVJPEG1 (0x0000002c)
#define NV2080_ENGINE_TYPE_NVJPEG2 (0x0000002d)
#define NV2080_ENGINE_TYPE_NVJPEG3 (0x0000002e)
#define NV2080_ENGINE_TYPE_NVJPEG4 (0x0000002f)
#define NV2080_ENGINE_TYPE_NVJPEG5 (0x00000030)
#define NV2080_ENGINE_TYPE_NVJPEG6 (0x00000031)
#define NV2080_ENGINE_TYPE_NVJPEG7 (0x00000032)
#define NV2080_ENGINE_TYPE_NVJPEG_IDX(i) ((i) - NV2080_ENGINE_TYPE_NVJPEG0)
#define NV2080_ENGINE_TYPE_NVJPEG_SIZE 8
#define NV2080_ENGINE_TYPE_NVJPG (0x0000002b)
#define NV2080_ENGINE_TYPE_OFA (0x00000033)
#define NV2080_ENGINE_TYPE_OFA0 NV2080_ENGINE_TYPE_OFA
#define NV2080_ENGINE_TYPE_OFA1 (0x0000003e)
#define NV2080_ENGINE_TYPE_OFA_IDX(i) ((i == NV2080_ENGINE_TYPE_OFA0) ? ((i) - NV2080_ENGINE_TYPE_OFA0) : ((i) - NV2080_ENGINE_TYPE_OFA1 + 1))
#define NV2080_ENGINE_TYPE_OFA_SIZE 2
#define NV2080_ENGINE_TYPE_OFAn(i) ((i == 0) ? (NV2080_ENGINE_TYPE_OFA0) : (NV2080_ENGINE_TYPE_OFA1))
#define NV2080_ENGINE_TYPE_PMU (0x00000029)
#define NV2080_ENGINE_TYPE_PPP (0x00000020)
#define NV2080_ENGINE_TYPE_SEC2 (0x00000026)
#define NV2080_ENGINE_TYPE_SW (0x00000022)
#define NV2080_ENGINE_TYPE_TSEC NV2080_ENGINE_TYPE_CIPHER
#define NV2080_ENGINE_TYPE_VIC (0x00000024)
#define NV2080_ENGINE_TYPE_VP (0x0000001e)

ABI_CHECK_SIZE_EQ(NV2080_INTR_CATEGORY_SUBTREE_MAP, 2);
ABI_CHECK_FIELD(NV2080_INTR_CATEGORY_SUBTREE_MAP, subtreeStart, 0, 1);
ABI_CHECK_FIELD(NV2080_INTR_CATEGORY_SUBTREE_MAP, subtreeEnd, 1, 1);

#define NV2080_NOTIFIERS_ACPI_NOTIFY (42)
#define NV2080_NOTIFIERS_AUDIO_HDCP_REQUEST (45)
#define NV2080_NOTIFIERS_AUX_POWER_EVENT (181)
#define NV2080_NOTIFIERS_AUX_POWER_STATE_CHANGE (182)
#define NV2080_NOTIFIERS_CE(x) (((x) < 10) ? (NV2080_NOTIFIERS_CE0 + (x)) : (NV2080_NOTIFIERS_CE10 + (x) - 10))
#define NV2080_NOTIFIERS_CE0 (23)
#define NV2080_NOTIFIERS_CE1 (24)
#define NV2080_NOTIFIERS_CE10 (166)
#define NV2080_NOTIFIERS_CE11 (167)
#define NV2080_NOTIFIERS_CE12 (168)
#define NV2080_NOTIFIERS_CE13 (169)
#define NV2080_NOTIFIERS_CE14 (170)
#define NV2080_NOTIFIERS_CE15 (171)
#define NV2080_NOTIFIERS_CE16 (172)
#define NV2080_NOTIFIERS_CE17 (173)
#define NV2080_NOTIFIERS_CE18 (174)
#define NV2080_NOTIFIERS_CE19 (175)
#define NV2080_NOTIFIERS_CE2 (25)
#define NV2080_NOTIFIERS_CE3 (26)
#define NV2080_NOTIFIERS_CE4 (27)
#define NV2080_NOTIFIERS_CE5 (28)
#define NV2080_NOTIFIERS_CE6 (29)
#define NV2080_NOTIFIERS_CE7 (30)
#define NV2080_NOTIFIERS_CE8 (31)
#define NV2080_NOTIFIERS_CE9 (32)
#define NV2080_NOTIFIERS_CE_IDX(x) (((x) <= NV2080_NOTIFIERS_CE9) ? ((x) - NV2080_NOTIFIERS_CE0) : ((x) - NV2080_NOTIFIERS_CE10 + 10))
#define NV2080_NOTIFIERS_CLOCKS_CHANGE (119)
#define NV2080_NOTIFIERS_COOLER_DIAG_ZONE (43)
#define NV2080_NOTIFIERS_CTXSW_TIMEOUT (140)
#define NV2080_NOTIFIERS_CTXSW_UCODE_ERROR (195)
#define NV2080_NOTIFIERS_DP_IRQ (7)
#define NV2080_NOTIFIERS_DRAM_RETIREMENT_EVENT (188)
#define NV2080_NOTIFIERS_DRAM_RETIREMENT_FAILURE (189)
#define NV2080_NOTIFIERS_DSTATE_HDA (154)
#define NV2080_NOTIFIERS_DSTATE_XUSB_PPC (143)
#define NV2080_NOTIFIERS_ECC_DBE (112)
#define NV2080_NOTIFIERS_ECC_SBE (111)
#define NV2080_NOTIFIERS_ECC_SBE_STORM (187)
#define NV2080_NOTIFIERS_EVENTBUFFER (6)
#define NV2080_NOTIFIERS_FECS_CTX_SWITCH (144)
#define NV2080_NOTIFIERS_FIFO_EVENT_MTHD (35)
#define NV2080_NOTIFIERS_FULL_SCREEN_CHANGE (5)
#define NV2080_NOTIFIERS_GC5_GPU_READY (114)
#define NV2080_NOTIFIERS_GC6_REFCOUNT_DEC (117)
#define NV2080_NOTIFIERS_GC6_REFCOUNT_INC (116)
#define NV2080_NOTIFIERS_GPIO_0_FALLING_INTERRUPT (79)
#define NV2080_NOTIFIERS_GPIO_0_RISING_INTERRUPT (47)
#define NV2080_NOTIFIERS_GPIO_10_FALLING_INTERRUPT (89)
#define NV2080_NOTIFIERS_GPIO_10_RISING_INTERRUPT (57)
#define NV2080_NOTIFIERS_GPIO_11_FALLING_INTERRUPT (90)
#define NV2080_NOTIFIERS_GPIO_11_RISING_INTERRUPT (58)
#define NV2080_NOTIFIERS_GPIO_12_FALLING_INTERRUPT (91)
#define NV2080_NOTIFIERS_GPIO_12_RISING_INTERRUPT (59)
#define NV2080_NOTIFIERS_GPIO_13_FALLING_INTERRUPT (92)
#define NV2080_NOTIFIERS_GPIO_13_RISING_INTERRUPT (60)
#define NV2080_NOTIFIERS_GPIO_14_FALLING_INTERRUPT (93)
#define NV2080_NOTIFIERS_GPIO_14_RISING_INTERRUPT (61)
#define NV2080_NOTIFIERS_GPIO_15_FALLING_INTERRUPT (94)
#define NV2080_NOTIFIERS_GPIO_15_RISING_INTERRUPT (62)
#define NV2080_NOTIFIERS_GPIO_16_FALLING_INTERRUPT (95)
#define NV2080_NOTIFIERS_GPIO_16_RISING_INTERRUPT (63)
#define NV2080_NOTIFIERS_GPIO_17_FALLING_INTERRUPT (96)
#define NV2080_NOTIFIERS_GPIO_17_RISING_INTERRUPT (64)
#define NV2080_NOTIFIERS_GPIO_18_FALLING_INTERRUPT (97)
#define NV2080_NOTIFIERS_GPIO_18_RISING_INTERRUPT (65)
#define NV2080_NOTIFIERS_GPIO_19_FALLING_INTERRUPT (98)
#define NV2080_NOTIFIERS_GPIO_19_RISING_INTERRUPT (66)
#define NV2080_NOTIFIERS_GPIO_1_FALLING_INTERRUPT (80)
#define NV2080_NOTIFIERS_GPIO_1_RISING_INTERRUPT (48)
#define NV2080_NOTIFIERS_GPIO_20_FALLING_INTERRUPT (99)
#define NV2080_NOTIFIERS_GPIO_20_RISING_INTERRUPT (67)
#define NV2080_NOTIFIERS_GPIO_21_FALLING_INTERRUPT (100)
#define NV2080_NOTIFIERS_GPIO_21_RISING_INTERRUPT (68)
#define NV2080_NOTIFIERS_GPIO_22_FALLING_INTERRUPT (101)
#define NV2080_NOTIFIERS_GPIO_22_RISING_INTERRUPT (69)
#define NV2080_NOTIFIERS_GPIO_23_FALLING_INTERRUPT (102)
#define NV2080_NOTIFIERS_GPIO_23_RISING_INTERRUPT (70)
#define NV2080_NOTIFIERS_GPIO_24_FALLING_INTERRUPT (103)
#define NV2080_NOTIFIERS_GPIO_24_RISING_INTERRUPT (71)
#define NV2080_NOTIFIERS_GPIO_25_FALLING_INTERRUPT (104)
#define NV2080_NOTIFIERS_GPIO_25_RISING_INTERRUPT (72)
#define NV2080_NOTIFIERS_GPIO_26_FALLING_INTERRUPT (105)
#define NV2080_NOTIFIERS_GPIO_26_RISING_INTERRUPT (73)
#define NV2080_NOTIFIERS_GPIO_27_FALLING_INTERRUPT (106)
#define NV2080_NOTIFIERS_GPIO_27_RISING_INTERRUPT (74)
#define NV2080_NOTIFIERS_GPIO_28_FALLING_INTERRUPT (107)
#define NV2080_NOTIFIERS_GPIO_28_RISING_INTERRUPT (75)
#define NV2080_NOTIFIERS_GPIO_29_FALLING_INTERRUPT (108)
#define NV2080_NOTIFIERS_GPIO_29_RISING_INTERRUPT (76)
#define NV2080_NOTIFIERS_GPIO_2_FALLING_INTERRUPT (81)
#define NV2080_NOTIFIERS_GPIO_2_RISING_INTERRUPT (49)
#define NV2080_NOTIFIERS_GPIO_30_FALLING_INTERRUPT (109)
#define NV2080_NOTIFIERS_GPIO_30_RISING_INTERRUPT (77)
#define NV2080_NOTIFIERS_GPIO_31_FALLING_INTERRUPT (110)
#define NV2080_NOTIFIERS_GPIO_31_RISING_INTERRUPT (78)
#define NV2080_NOTIFIERS_GPIO_3_FALLING_INTERRUPT (82)
#define NV2080_NOTIFIERS_GPIO_3_RISING_INTERRUPT (50)
#define NV2080_NOTIFIERS_GPIO_4_FALLING_INTERRUPT (83)
#define NV2080_NOTIFIERS_GPIO_4_RISING_INTERRUPT (51)
#define NV2080_NOTIFIERS_GPIO_5_FALLING_INTERRUPT (84)
#define NV2080_NOTIFIERS_GPIO_5_RISING_INTERRUPT (52)
#define NV2080_NOTIFIERS_GPIO_6_FALLING_INTERRUPT (85)
#define NV2080_NOTIFIERS_GPIO_6_RISING_INTERRUPT (53)
#define NV2080_NOTIFIERS_GPIO_7_FALLING_INTERRUPT (86)
#define NV2080_NOTIFIERS_GPIO_7_RISING_INTERRUPT (54)
#define NV2080_NOTIFIERS_GPIO_8_FALLING_INTERRUPT (87)
#define NV2080_NOTIFIERS_GPIO_8_RISING_INTERRUPT (55)
#define NV2080_NOTIFIERS_GPIO_9_FALLING_INTERRUPT (88)
#define NV2080_NOTIFIERS_GPIO_9_RISING_INTERRUPT (56)
#define NV2080_NOTIFIERS_GPIO_FALLING_INTERRUPT(pin) (NV2080_NOTIFIERS_GPIO_0_FALLING_INTERRUPT + (pin))
#define NV2080_NOTIFIERS_GPIO_RISING_INTERRUPT(pin) (NV2080_NOTIFIERS_GPIO_0_RISING_INTERRUPT + (pin))
#define NV2080_NOTIFIERS_GPU_RECOVERY_ACTION (192)
#define NV2080_NOTIFIERS_GPU_UNAVAILABLE (191)
#define NV2080_NOTIFIERS_GR(x) ((x == 0) ? (NV2080_NOTIFIERS_GR0) : (NV2080_NOTIFIERS_GR1 + (x - 1)))
#define NV2080_NOTIFIERS_GR0 NV2080_NOTIFIERS_GRAPHICS
#define NV2080_NOTIFIERS_GR1 (146)
#define NV2080_NOTIFIERS_GR2 (147)
#define NV2080_NOTIFIERS_GR3 (148)
#define NV2080_NOTIFIERS_GR4 (149)
#define NV2080_NOTIFIERS_GR5 (150)
#define NV2080_NOTIFIERS_GR6 (151)
#define NV2080_NOTIFIERS_GR7 (152)
#define NV2080_NOTIFIERS_GRAPHICS (12)
#define NV2080_NOTIFIERS_GR_DEBUG_INTR (8)
#define NV2080_NOTIFIERS_GR_IDX(x) ((x) - NV2080_NOTIFIERS_GR0)
#define NV2080_NOTIFIERS_GSP_PERF_TRACE (184)
#define NV2080_NOTIFIERS_HDCP_STATUS_CHANGE (34)
#define NV2080_NOTIFIERS_HDMI_FRL_RETRAINING_REQUEST (178)
#define NV2080_NOTIFIERS_HOTPLUG (1)
#define NV2080_NOTIFIERS_HOTPLUG_PROCESSING_COMPLETE (120)
#define NV2080_NOTIFIERS_INBAND_RESPONSE (185)
#define NV2080_NOTIFIERS_INFOROM_ECC_OBJECT_UPDATED (141)
#define NV2080_NOTIFIERS_INFOROM_PBL_OBJECT_UPDATED (161)
#define NV2080_NOTIFIERS_INFOROM_RRL_OBJECT_UPDATED (160)
#define NV2080_NOTIFIERS_LPWR_DIFR_PREFETCH_REQUEST (162)
#define NV2080_NOTIFIERS_MAXCOUNT (197)
#define NV2080_NOTIFIERS_MSENC (38)
#define NV2080_NOTIFIERS_NVDEC(x) (NV2080_NOTIFIERS_NVDEC0 + (x))
#define NV2080_NOTIFIERS_NVDEC0 NV2080_NOTIFIERS_VLD
#define NV2080_NOTIFIERS_NVDEC1 (15)
#define NV2080_NOTIFIERS_NVDEC2 (16)
#define NV2080_NOTIFIERS_NVDEC3 (17)
#define NV2080_NOTIFIERS_NVDEC4 (18)
#define NV2080_NOTIFIERS_NVDEC5 (19)
#define NV2080_NOTIFIERS_NVDEC6 (20)
#define NV2080_NOTIFIERS_NVDEC7 (21)
#define NV2080_NOTIFIERS_NVDEC_IDX(x) ((x) - NV2080_NOTIFIERS_NVDEC0)
#define NV2080_NOTIFIERS_NVENC(x) (((x) < 3) ? (NV2080_NOTIFIERS_NVENC0 + (x)) : (NV2080_NOTIFIERS_NVENC3 + (x) - 3))
#define NV2080_NOTIFIERS_NVENC0 NV2080_NOTIFIERS_MSENC
#define NV2080_NOTIFIERS_NVENC1 (39)
#define NV2080_NOTIFIERS_NVENC2 (40)
#define NV2080_NOTIFIERS_NVENC3 (183)
#define NV2080_NOTIFIERS_NVENC_IDX(x) (((x) <= NV2080_NOTIFIERS_NVENC2) ? ((x) - NV2080_NOTIFIERS_NVENC0) : ((x) - NV2080_NOTIFIERS_NVENC3 + 3))
#define NV2080_NOTIFIERS_NVJPEG(x) (NV2080_NOTIFIERS_NVJPEG0 + (x))
#define NV2080_NOTIFIERS_NVJPEG0 NV2080_NOTIFIERS_NVJPG
#define NV2080_NOTIFIERS_NVJPEG1 (127)
#define NV2080_NOTIFIERS_NVJPEG2 (128)
#define NV2080_NOTIFIERS_NVJPEG3 (129)
#define NV2080_NOTIFIERS_NVJPEG4 (130)
#define NV2080_NOTIFIERS_NVJPEG5 (131)
#define NV2080_NOTIFIERS_NVJPEG6 (132)
#define NV2080_NOTIFIERS_NVJPEG7 (133)
#define NV2080_NOTIFIERS_NVJPEG_IDX(x) ((x) - NV2080_NOTIFIERS_NVJPEG0)
#define NV2080_NOTIFIERS_NVJPG (126)
#define NV2080_NOTIFIERS_NVLINK_ERROR_FATAL (123)
#define NV2080_NOTIFIERS_NVLINK_ERROR_RECOVERY_REQUIRED (125)
#define NV2080_NOTIFIERS_NVLINK_INFO_LINK_DOWN (176)
#define NV2080_NOTIFIERS_NVLINK_INFO_LINK_UP (165)
#define NV2080_NOTIFIERS_NVLINK_UNCONTAINED_ERROR (190)
#define NV2080_NOTIFIERS_NVPCF_EVENTS (177)
#define NV2080_NOTIFIERS_NVTELEMETRY_REPORT_EVENT (142)
#define NV2080_NOTIFIERS_OFA (153)
#define NV2080_NOTIFIERS_OFA0 NV2080_NOTIFIERS_OFA
#define NV2080_NOTIFIERS_OFA1 (180)
#define NV2080_NOTIFIERS_OFA_IDX(x) ((x == NV2080_NOTIFIERS_OFA0) ? ((x) - NV2080_NOTIFIERS_OFA0) : ((x) - NV2080_NOTIFIERS_OFA1 + 1))
#define NV2080_NOTIFIERS_OFAn(x) ((x == 0) ? (NV2080_NOTIFIERS_OFA0) : (NV2080_NOTIFIERS_OFA1))
#define NV2080_NOTIFIERS_PDEC (22)
#define NV2080_NOTIFIERS_PHYSICAL_PAGE_FAULT (121)
#define NV2080_NOTIFIERS_PLATFORM_POWER_MODE_CHANGE (158)
#define NV2080_NOTIFIERS_PMU_COMMAND (10)
#define NV2080_NOTIFIERS_PMU_EVENT (9)
#define NV2080_NOTIFIERS_POISON_ERROR_FATAL (156)
#define NV2080_NOTIFIERS_POISON_ERROR_NON_FATAL (155)
#define NV2080_NOTIFIERS_POWER_CONNECTOR (2)
#define NV2080_NOTIFIERS_POWER_EVENT (118)
#define NV2080_NOTIFIERS_POWER_RESUME (194)
#define NV2080_NOTIFIERS_POWER_SUSPEND (193)
#define NV2080_NOTIFIERS_PPP (13)
#define NV2080_NOTIFIERS_PRIV_REG_ACCESS_FAULT (124)
#define NV2080_NOTIFIERS_PRIV_RING_HANG (36)
#define NV2080_NOTIFIERS_PSTATE_CHANGE (33)
#define NV2080_NOTIFIERS_RC_ERROR (37)
#define NV2080_NOTIFIERS_RESERVED122 (122)
#define NV2080_NOTIFIERS_RESERVED_186 (186)
#define NV2080_NOTIFIERS_RUNLIST_ACQUIRE (135)
#define NV2080_NOTIFIERS_RUNLIST_ACQUIRE_AND_ENG_IDLE (136)
#define NV2080_NOTIFIERS_RUNLIST_AND_ENG_IDLE (134)
#define NV2080_NOTIFIERS_RUNLIST_IDLE (137)
#define NV2080_NOTIFIERS_RUNLIST_PREEMPT_COMPLETE (139)
#define NV2080_NOTIFIERS_SEC2 (115)
#define NV2080_NOTIFIERS_SEC_FAULT_ERROR (163)
#define NV2080_NOTIFIERS_SMC_CONFIG_UPDATE (159)
#define NV2080_NOTIFIERS_STEREO_EMITTER_DETECTION (113)
#define NV2080_NOTIFIERS_SW (0)
#define NV2080_NOTIFIERS_THERMAL_DIAG_ZONE (44)
#define NV2080_NOTIFIERS_THERMAL_HW (4)
#define NV2080_NOTIFIERS_THERMAL_SW (3)
#define NV2080_NOTIFIERS_TIMER (11)
#define NV2080_NOTIFIERS_TSG_PREEMPT_COMPLETE (138)
#define NV2080_NOTIFIERS_UCODE_RESET (157)
#define NV2080_NOTIFIERS_UNUSED_0 (41)
#define NV2080_NOTIFIERS_UNUSED_1 (164)
#define NV2080_NOTIFIERS_USE_GC6_REDUCED_THRESHOLD (196)
#define NV2080_NOTIFIERS_VLD (14)
#define NV2080_NOTIFIERS_VRR_SET_TIMEOUT (179)
#define NV2080_NOTIFIERS_WORKLOAD_MODULATION_CHANGE (46)
#define NV2080_NOTIFIERS_XUSB_PPC_CONNECTED (145)
#define NV20_SUBDEVICE_0 (0x2080U)

ABI_CHECK_SIZE_EQ(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, 40);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, channelInstance, 0, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, hObjectBuffer, 4, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, hObjectNotify, 8, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, offset, 12, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, pControl, 16, 8);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, flags, 24, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, channelPBSize, 28, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS, subDeviceId, 32, 4);


ABI_CHECK_SIZE_EQ(NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS, 16);
ABI_CHECK_FIELD(NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS, channelInstance, 0, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS, hObjectNotify, 4, 4);
ABI_CHECK_FIELD(NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS, pControl, 8, 8);

#define NV90F1_CTRL_CMD_VASPACE_COPY_SERVER_RESERVED_PDES (0x90f10106U)

ABI_CHECK_SIZE_EQ(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, 184);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, hSubDevice, 0, 4);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, subDeviceId, 4, 4);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, pageSize, 8, 8);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, virtAddrLo, 16, 8);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, virtAddrHi, 24, 8);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, numLevelsToCopy, 32, 4);
ABI_CHECK_FIELD(NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS, levels, 40, 144);


ABI_CHECK_SIZE_EQ(NVA06F_CTRL_BIND_PARAMS, 4);
ABI_CHECK_FIELD(NVA06F_CTRL_BIND_PARAMS, engineType, 0, 4);

#define NVA06F_CTRL_CMD_BIND (0xa06f0104)
#define NVA06F_CTRL_CMD_GPFIFO_SCHEDULE (0xa06f0103)

ABI_CHECK_SIZE_EQ(NVA06F_CTRL_GPFIFO_SCHEDULE_PARAMS, 2);
ABI_CHECK_FIELD(NVA06F_CTRL_GPFIFO_SCHEDULE_PARAMS, bEnable, 0, 1);
ABI_CHECK_FIELD(NVA06F_CTRL_GPFIFO_SCHEDULE_PARAMS, bSkipSubmit, 1, 1);


ABI_CHECK_SIZE_EQ(NVC0B5_ALLOCATION_PARAMETERS, 8);
ABI_CHECK_FIELD(NVC0B5_ALLOCATION_PARAMETERS, version, 0, 4);
ABI_CHECK_FIELD(NVC0B5_ALLOCATION_PARAMETERS, engineType, 4, 4);


ABI_CHECK_SIZE_EQ(NVOS00_PARAMETERS_v03_00, 16);
ABI_CHECK_FIELD(NVOS00_PARAMETERS_v03_00, hRoot, 0, 4);
ABI_CHECK_FIELD(NVOS00_PARAMETERS_v03_00, hObjectParent, 4, 4);
ABI_CHECK_FIELD(NVOS00_PARAMETERS_v03_00, hObjectOld, 8, 4);
ABI_CHECK_FIELD(NVOS00_PARAMETERS_v03_00, status, 12, 4);

#define NVOS02_FLAGS_ALLOC 17:16
#define NVOS02_FLAGS_ALLOC_DEVICE_READ_ONLY 22:22
#define NVOS02_FLAGS_ALLOC_DEVICE_READ_ONLY_NO (0x00000000)
#define NVOS02_FLAGS_ALLOC_DEVICE_READ_ONLY_YES (0x00000001)
#define NVOS02_FLAGS_ALLOC_NISO_DISPLAY 20:20
#define NVOS02_FLAGS_ALLOC_NISO_DISPLAY_NO (0x00000000)
#define NVOS02_FLAGS_ALLOC_NISO_DISPLAY_YES (0x00000001)
#define NVOS02_FLAGS_ALLOC_NONE (0x00000001)
#define NVOS02_FLAGS_ALLOC_TYPE_SYNCPOINT 24:24
#define NVOS02_FLAGS_ALLOC_TYPE_SYNCPOINT_APERTURE (0x00000001)
#define NVOS02_FLAGS_ALLOC_USER_READ_ONLY 21:21
#define NVOS02_FLAGS_ALLOC_USER_READ_ONLY_NO (0x00000000)
#define NVOS02_FLAGS_ALLOC_USER_READ_ONLY_YES (0x00000001)
#define NVOS02_FLAGS_COHERENCY 15:12
#define NVOS02_FLAGS_COHERENCY_CACHED (0x00000001)
#define NVOS02_FLAGS_COHERENCY_UNCACHED (0x00000000)
#define NVOS02_FLAGS_COHERENCY_WRITE_BACK (0x00000005)
#define NVOS02_FLAGS_COHERENCY_WRITE_COMBINE (0x00000002)
#define NVOS02_FLAGS_COHERENCY_WRITE_PROTECT (0x00000004)
#define NVOS02_FLAGS_COHERENCY_WRITE_THROUGH (0x00000003)
#define NVOS02_FLAGS_GPU_CACHEABLE 18:18
#define NVOS02_FLAGS_GPU_CACHEABLE_NO (0x00000000)
#define NVOS02_FLAGS_GPU_CACHEABLE_YES (0x00000001)
#define NVOS02_FLAGS_KERNEL_MAPPING 19:19
#define NVOS02_FLAGS_KERNEL_MAPPING_MAP (0x00000001)
#define NVOS02_FLAGS_KERNEL_MAPPING_NO_MAP (0x00000000)
#define NVOS02_FLAGS_LOCATION 11:8
#define NVOS02_FLAGS_LOCATION_PCI (0x00000000)
#define NVOS02_FLAGS_LOCATION_VIDMEM (0x00000002)
#define NVOS02_FLAGS_MAPPING 31:30
#define NVOS02_FLAGS_MAPPING_DEFAULT (0x00000000)
#define NVOS02_FLAGS_MAPPING_NEVER_MAP (0x00000002)
#define NVOS02_FLAGS_MAPPING_NO_MAP (0x00000001)
#define NVOS02_FLAGS_MEMORY_PROTECTION 26:25
#define NVOS02_FLAGS_MEMORY_PROTECTION_DEFAULT (0x00000000)
#define NVOS02_FLAGS_MEMORY_PROTECTION_PROTECTED (0x00000001)
#define NVOS02_FLAGS_MEMORY_PROTECTION_UNPROTECTED (0x00000002)
#define NVOS02_FLAGS_PEER_MAP_OVERRIDE 23:23
#define NVOS02_FLAGS_PEER_MAP_OVERRIDE_DEFAULT (0x00000000)
#define NVOS02_FLAGS_PEER_MAP_OVERRIDE_REQUIRED (0x00000001)
#define NVOS02_FLAGS_PHYSICALITY 7:4
#define NVOS02_FLAGS_PHYSICALITY_CONTIGUOUS (0x00000000)
#define NVOS02_FLAGS_PHYSICALITY_NONCONTIGUOUS (0x00000001)
#define NVOS02_FLAGS_REGISTER_MEMDESC_TO_PHYS_RM 27:27
#define NVOS02_FLAGS_REGISTER_MEMDESC_TO_PHYS_RM_FALSE (0x00000000)
#define NVOS02_FLAGS_REGISTER_MEMDESC_TO_PHYS_RM_TRUE (0x00000001)
#define NVOS04_FLAGS_CC_SECURE 2:2
#define NVOS04_FLAGS_CC_SECURE_FALSE 0x00000000
#define NVOS04_FLAGS_CC_SECURE_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_CLIENT_MAP_FIFO 24:24
#define NVOS04_FLAGS_CHANNEL_CLIENT_MAP_FIFO_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_CLIENT_MAP_FIFO_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_DENY_AUTH_LEVEL_PRIV 22:22
#define NVOS04_FLAGS_CHANNEL_DENY_AUTH_LEVEL_PRIV_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_DENY_AUTH_LEVEL_PRIV_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_DENY_PHYSICAL_MODE_CE 7:7
#define NVOS04_FLAGS_CHANNEL_DENY_PHYSICAL_MODE_CE_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_DENY_PHYSICAL_MODE_CE_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_PBDMA_ACQUIRE_TIMEOUT 27:27
#define NVOS04_FLAGS_CHANNEL_PBDMA_ACQUIRE_TIMEOUT_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_PBDMA_ACQUIRE_TIMEOUT_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_SKIP_MAP_REFCOUNTING 3:3
#define NVOS04_FLAGS_CHANNEL_SKIP_MAP_REFCOUNTING_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_SKIP_MAP_REFCOUNTING_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_SKIP_SCRUBBER 23:23
#define NVOS04_FLAGS_CHANNEL_SKIP_SCRUBBER_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_SKIP_SCRUBBER_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_TYPE 1:0
#define NVOS04_FLAGS_CHANNEL_TYPE_PHYSICAL 0x00000000
#define NVOS04_FLAGS_CHANNEL_TYPE_PHYSICAL_FOR_VIRTUAL 0x00000002
#define NVOS04_FLAGS_CHANNEL_TYPE_VIRTUAL 0x00000001
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_FIXED 11:11
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_FIXED_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_FIXED_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_FIXED 21:21
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_FIXED_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_FIXED_TRUE 0x00000001
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_VALUE 20:12
#define NVOS04_FLAGS_CHANNEL_USERD_INDEX_VALUE 10:8
#define NVOS04_FLAGS_CHANNEL_VGPU_PLUGIN_CONTEXT 26:26
#define NVOS04_FLAGS_CHANNEL_VGPU_PLUGIN_CONTEXT_FALSE 0x00000000
#define NVOS04_FLAGS_CHANNEL_VGPU_PLUGIN_CONTEXT_TRUE 0x00000001
#define NVOS04_FLAGS_DELAY_CHANNEL_SCHEDULING 6:6
#define NVOS04_FLAGS_DELAY_CHANNEL_SCHEDULING_FALSE 0x00000000
#define NVOS04_FLAGS_DELAY_CHANNEL_SCHEDULING_TRUE 0x00000001
#define NVOS04_FLAGS_GROUP_CHANNEL_RUNQUEUE 4:4
#define NVOS04_FLAGS_GROUP_CHANNEL_RUNQUEUE_DEFAULT 0x00000000
#define NVOS04_FLAGS_GROUP_CHANNEL_RUNQUEUE_ONE 0x00000001
#define NVOS04_FLAGS_GROUP_CHANNEL_THREAD 29:28
#define NVOS04_FLAGS_GROUP_CHANNEL_THREAD_DEFAULT 0x00000000
#define NVOS04_FLAGS_GROUP_CHANNEL_THREAD_ONE 0x00000001
#define NVOS04_FLAGS_GROUP_CHANNEL_THREAD_TWO 0x00000002
#define NVOS04_FLAGS_MAP_CHANNEL 30:30
#define NVOS04_FLAGS_MAP_CHANNEL_FALSE 0x00000000
#define NVOS04_FLAGS_MAP_CHANNEL_TRUE 0x00000001
#define NVOS04_FLAGS_PRIVILEGED_CHANNEL 5:5
#define NVOS04_FLAGS_PRIVILEGED_CHANNEL_FALSE 0x00000000
#define NVOS04_FLAGS_PRIVILEGED_CHANNEL_TRUE 0x00000001
#define NVOS04_FLAGS_SET_EVICT_LAST_CE_PREFETCH_CHANNEL 25:25
#define NVOS04_FLAGS_SET_EVICT_LAST_CE_PREFETCH_CHANNEL_FALSE 0x00000000
#define NVOS04_FLAGS_SET_EVICT_LAST_CE_PREFETCH_CHANNEL_TRUE 0x00000001
#define NVOS04_FLAGS_SKIP_CTXBUFFER_ALLOC 31:31
#define NVOS04_FLAGS_SKIP_CTXBUFFER_ALLOC_FALSE 0x00000000
#define NVOS04_FLAGS_SKIP_CTXBUFFER_ALLOC_TRUE 0x00000001
#define NVOS04_FLAGS_VPR 2:2
#define NVOS04_FLAGS_VPR_FALSE 0x00000000
#define NVOS04_FLAGS_VPR_TRUE 0x00000001

ABI_CHECK_SIZE_EQ(NV_BSP_ALLOCATION_PARAMETERS, 12);
ABI_CHECK_FIELD(NV_BSP_ALLOCATION_PARAMETERS, size, 0, 4);
ABI_CHECK_FIELD(NV_BSP_ALLOCATION_PARAMETERS, prohibitMultipleInstances, 4, 4);
ABI_CHECK_FIELD(NV_BSP_ALLOCATION_PARAMETERS, engineInstance, 8, 4);


ABI_CHECK_SIZE_EQ(NV_CHANNEL_ALLOC_PARAMS, 368);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hObjectError, 0, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hObjectBuffer, 4, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, gpFifoOffset, 8, 8);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, gpFifoEntries, 16, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, flags, 20, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hContextShare, 24, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hVASpace, 28, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hUserdMemory, 32, 32);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, userdOffset, 64, 64);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, engineType, 128, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, cid, 132, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, subDeviceId, 136, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hObjectEccError, 140, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, instanceMem, 144, 24);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, userdMem, 168, 24);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, ramfcMem, 192, 24);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, mthdbufMem, 216, 24);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hPhysChannelGroup, 240, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, internalFlags, 244, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, errorNotifierMem, 248, 24);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, eccErrorNotifierMem, 272, 24);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, ProcessID, 296, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, SubProcessID, 300, 4);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, encryptIv, 304, 12);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, decryptIv, 316, 12);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, hmacNonce, 328, 32);
ABI_CHECK_FIELD(NV_CHANNEL_ALLOC_PARAMS, tpcConfigID, 360, 4);

#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ECC_ERROR_NOTIFIER_TYPE 5:4
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ECC_ERROR_NOTIFIER_TYPE_CTXDMA ERROR_NOTIFIER_TYPE_CTXDMA
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ECC_ERROR_NOTIFIER_TYPE_MEMORY ERROR_NOTIFIER_TYPE_MEMORY
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ECC_ERROR_NOTIFIER_TYPE_NONE ERROR_NOTIFIER_TYPE_NONE
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ECC_ERROR_NOTIFIER_TYPE_UNKNOWN ERROR_NOTIFIER_TYPE_UNKNOWN
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ERROR_NOTIFIER_TYPE 3:2
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ERROR_NOTIFIER_TYPE_CTXDMA ERROR_NOTIFIER_TYPE_CTXDMA
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ERROR_NOTIFIER_TYPE_MEMORY ERROR_NOTIFIER_TYPE_MEMORY
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ERROR_NOTIFIER_TYPE_NONE ERROR_NOTIFIER_TYPE_NONE
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_ERROR_NOTIFIER_TYPE_UNKNOWN ERROR_NOTIFIER_TYPE_UNKNOWN
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_GSP_OWNED 6:6
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_GSP_OWNED_NO 0x0
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_GSP_OWNED_YES 0x1
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_PRIVILEGE 1:0
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_PRIVILEGE_ADMIN 0x1
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_PRIVILEGE_KERNEL 0x2
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_PRIVILEGE_USER 0x0
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_UVM_OWNED 7:7
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_UVM_OWNED_NO 0x0
#define NV_KERNELCHANNEL_ALLOC_INTERNALFLAGS_UVM_OWNED_YES 0x1

ABI_CHECK_SIZE_EQ(NV_MEMORY_DESC_PARAMS, 24);
ABI_CHECK_FIELD(NV_MEMORY_DESC_PARAMS, base, 0, 8);
ABI_CHECK_FIELD(NV_MEMORY_DESC_PARAMS, size, 8, 8);
ABI_CHECK_FIELD(NV_MEMORY_DESC_PARAMS, addressSpace, 16, 4);
ABI_CHECK_FIELD(NV_MEMORY_DESC_PARAMS, cacheAttrib, 20, 4);

#define NV_MEMORY_WRITECOMBINED 2

ABI_CHECK_SIZE_EQ(NV_MSENC_ALLOCATION_PARAMETERS, 12);
ABI_CHECK_FIELD(NV_MSENC_ALLOCATION_PARAMETERS, size, 0, 4);
ABI_CHECK_FIELD(NV_MSENC_ALLOCATION_PARAMETERS, prohibitMultipleInstances, 4, 4);
ABI_CHECK_FIELD(NV_MSENC_ALLOCATION_PARAMETERS, engineInstance, 8, 4);


ABI_CHECK_SIZE_EQ(NV_NVJPG_ALLOCATION_PARAMETERS, 12);
ABI_CHECK_FIELD(NV_NVJPG_ALLOCATION_PARAMETERS, size, 0, 4);
ABI_CHECK_FIELD(NV_NVJPG_ALLOCATION_PARAMETERS, prohibitMultipleInstances, 4, 4);
ABI_CHECK_FIELD(NV_NVJPG_ALLOCATION_PARAMETERS, engineInstance, 8, 4);


ABI_CHECK_SIZE_EQ(NV_OFA_ALLOCATION_PARAMETERS, 12);
ABI_CHECK_FIELD(NV_OFA_ALLOCATION_PARAMETERS, size, 0, 4);
ABI_CHECK_FIELD(NV_OFA_ALLOCATION_PARAMETERS, prohibitMultipleInstances, 4, 4);
ABI_CHECK_FIELD(NV_OFA_ALLOCATION_PARAMETERS, engineInstance, 8, 4);


ABI_CHECK_ENUM_VAL_EQ(NV_RPC_UPDATE_PDE_BAR_TYPE, NV_RPC_UPDATE_PDE_BAR_1, 0);
ABI_CHECK_ENUM_VAL_EQ(NV_RPC_UPDATE_PDE_BAR_TYPE, NV_RPC_UPDATE_PDE_BAR_2, 1);
ABI_CHECK_ENUM_VAL_EQ(NV_RPC_UPDATE_PDE_BAR_TYPE, NV_RPC_UPDATE_PDE_BAR_INVALID, 2);


#define NV_VASPACE_ALLOCATION_INDEX_GPU_NEW 0x00

ABI_CHECK_SIZE_EQ(NV_VASPACE_ALLOCATION_PARAMETERS, 48);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, index, 0, 4);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, flags, 4, 4);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, vaSize, 8, 8);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, vaStartInternal, 16, 8);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, vaLimitInternal, 24, 8);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, bigPageSize, 32, 4);
ABI_CHECK_FIELD(NV_VASPACE_ALLOCATION_PARAMETERS, vaBase, 40, 8);


ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_FIRST_EVENT, 4096);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_GSP_INIT_DONE, 4097);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_GSP_RUN_CPU_SEQUENCER, 4098);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_POST_EVENT, 4099);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_RC_TRIGGERED, 4100);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_MMU_FAULT_QUEUED, 4101);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_OS_ERROR_LOG, 4102);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_RG_LINE_INTR, 4103);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_GPUACCT_PERFMON_UTIL_SAMPLES, 4104);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_SIM_READ, 4105);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_SIM_WRITE, 4106);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_SEMAPHORE_SCHEDULE_CALLBACK, 4107);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_UCODE_LIBOS_PRINT, 4108);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_VGPU_GSP_PLUGIN_TRIGGERED, 4109);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_PERF_GPU_BOOST_SYNC_LIMITS_CALLBACK, 4110);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_PERF_BRIDGELESS_INFO_UPDATE, 4111);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_VGPU_CONFIG, 4112);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_DISPLAY_MODESET, 4113);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_EXTDEV_INTR_SERVICE, 4114);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_INBAND_RECEIVED_DATA_256, 4115);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_INBAND_RECEIVED_DATA_512, 4116);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_INBAND_RECEIVED_DATA_1024, 4117);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_INBAND_RECEIVED_DATA_2048, 4118);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_INBAND_RECEIVED_DATA_4096, 4119);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_TIMED_SEMAPHORE_RELEASE, 4120);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_IS_GPU_DEGRADED, 4121);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_PFM_REQ_HNDLR_STATE_SYNC_CALLBACK, 4122);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_FAULT_UP, 4123);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_GSP_LOCKDOWN_NOTICE, 4124);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_MIG_CI_CONFIG_UPDATE, 4125);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_UPDATE_GSP_TRACE, 4126);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NVLINK_FATAL_ERROR_RECOVERY, 4127);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_GSP_POST_NOCAT_RECORD, 4128);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_FECS_ERROR, 4129);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_RECOVERY_ACTION, 4130);
// Appending to the end of this enum is okay.
ABI_CHECK_ENUM_VAL_GE(NV_VGPU_MSG_EVENT, NV_VGPU_MSG_EVENT_NUM_EVENTS, 4131);



ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_NOP, 0);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_GUEST_SYSTEM_INFO, 1);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_ROOT, 2);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_DEVICE, 3);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_MEMORY, 4);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_CTX_DMA, 5);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_CHANNEL_DMA, 6);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_MAP_MEMORY, 7);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_BIND_CTX_DMA, 8);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_OBJECT, 9);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_FREE, 10);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_LOG, 11);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_VIDMEM, 12);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UNMAP_MEMORY, 13);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_MAP_MEMORY_DMA, 14);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UNMAP_MEMORY_DMA, 15);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_EDID, 16);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_DISP_CHANNEL, 17);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_DISP_OBJECT, 18);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_SUBDEVICE, 19);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_DYNAMIC_MEMORY, 20);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DUP_OBJECT, 21);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_IDLE_CHANNELS, 22);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_EVENT, 23);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SEND_EVENT, 24);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_REMAPPER_CONTROL, 25);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DMA_CONTROL, 26);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DMA_FILL_PTE_MEM, 27);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_MANAGE_HW_RESOURCE, 28);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_BIND_ARBITRARY_CTX_DMA, 29);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CREATE_FB_SEGMENT, 30);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DESTROY_FB_SEGMENT, 31);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_SHARE_DEVICE, 32);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DEFERRED_API_CONTROL, 33);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_REMOVE_DEFERRED_API, 34);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SIM_ESCAPE_READ, 35);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SIM_ESCAPE_WRITE, 36);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SIM_MANAGE_DISPLAY_CONTEXT_DMA, 37);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_FREE_VIDMEM_VIRT, 38);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_PERF_GET_PSTATE_INFO, 39);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_PERF_GET_PERFMON_SAMPLE, 40);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_PERF_GET_VIRTUAL_PSTATE_INFO, 41);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_PERF_GET_LEVEL_INFO, 42);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_MAP_SEMA_MEMORY, 43);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UNMAP_SEMA_MEMORY, 44);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_SURFACE_PROPERTIES, 45);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CLEANUP_SURFACE, 46);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UNLOADING_GUEST_DRIVER, 47);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_TDR_SET_TIMEOUT_STATE, 48);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SWITCH_TO_VGA, 49);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GPU_EXEC_REG_OPS, 50);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_STATIC_INFO, 51);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ALLOC_VIRTMEM, 52);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UPDATE_PDE_2, 53);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_PAGE_DIRECTORY, 54);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_STATIC_PSTATE_INFO, 55);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_TRANSLATE_GUEST_GPU_PTES, 56);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RESERVED_57, 57);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RESET_CURRENT_GR_CONTEXT, 58);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_SEMA_MEM_VALIDATION_STATE, 59);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_ENGINE_UTILIZATION, 60);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UPDATE_GPU_PDES, 61);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_ENCODER_CAPACITY, 62);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_VGPU_PF_REG_READ32, 63);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_GUEST_SYSTEM_INFO_EXT, 64);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_GSP_STATIC_INFO, 65);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RMFS_INIT, 66);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RMFS_CLOSE_QUEUE, 67);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RMFS_CLEANUP, 68);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RMFS_TEST, 69);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UPDATE_BAR_PDE, 70);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CONTINUATION_RECORD, 71);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GSP_SET_SYSTEM_INFO, 72);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_REGISTRY, 73);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GSP_INIT_POST_OBJGPU, 74);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SUBDEV_EVENT_SET_NOTIFICATION, 75);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GSP_RM_CONTROL, 76);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_STATIC_INFO2, 77);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DUMP_PROTOBUF_COMPONENT, 78);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UNSET_PAGE_DIRECTORY, 79);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_CONSOLIDATED_STATIC_INFO, 80);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GMMU_REGISTER_FAULT_BUFFER, 81);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GMMU_UNREGISTER_FAULT_BUFFER, 82);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER, 83);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER, 84);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_VGPU_FB_USAGE, 85);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_NVFBC_SW_SESSION_UPDATE_INFO, 86);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_NVENC_SW_SESSION_UPDATE_INFO, 87);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RESET_CHANNEL, 88);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RESET_ISOLATED_CHANNEL, 89);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_HANDLE_VF_PRI_FAULT, 90);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CLK_GET_EXTENDED_INFO, 91);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PERF_BOOST, 92);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PERF_VPSTATES_GET_CONTROL, 93);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_ZBC_CLEAR_TABLE, 94);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_ZBC_COLOR_CLEAR, 95);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_ZBC_DEPTH_CLEAR, 96);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPFIFO_SCHEDULE, 97);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_TIMESLICE, 98);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PREEMPT, 99);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FIFO_DISABLE_CHANNELS, 100);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_TSG_INTERLEAVE_LEVEL, 101);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_CHANNEL_INTERLEAVE_LEVEL, 102);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GSP_RM_ALLOC, 103);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_P2P_CAPS_V2, 104);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CIPHER_AES_ENCRYPT, 105);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CIPHER_SESSION_KEY, 106);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CIPHER_SESSION_KEY_STATUS, 107);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_CLEAR_ALL_SM_ERROR_STATES, 108);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_READ_ALL_SM_ERROR_STATES, 109);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SET_EXCEPTION_MASK, 110);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_PROMOTE_CTX, 111);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_CTXSW_PREEMPTION_BIND, 112);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_SET_CTXSW_PREEMPTION_MODE, 113);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_CTXSW_ZCULL_BIND, 114);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_INITIALIZE_CTX, 115);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES, 116);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FIFO_CLEAR_FAULTED_BIT, 117);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_LATEST_ECC_ADDRESSES, 118);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_MC_SERVICE_INTERRUPTS, 119);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DMA_SET_DEFAULT_VASPACE, 120);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_CE_PCE_MASK, 121);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_ZBC_CLEAR_TABLE_ENTRY, 122);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_NVLINK_PEER_ID_MASK, 123);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_NVLINK_STATUS, 124);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_P2P_CAPS, 125);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_P2P_CAPS_MATRIX, 126);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RESERVED_0, 127);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RESERVE_PM_AREA_SMPC, 128);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RESERVE_HWPM_LEGACY, 129);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_B0CC_EXEC_REG_OPS, 130);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_BIND_PM_RESOURCES, 131);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SUSPEND_CONTEXT, 132);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_RESUME_CONTEXT, 133);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_EXEC_REG_OPS, 134);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SET_MODE_MMU_DEBUG, 135);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_READ_SINGLE_SM_ERROR_STATE, 136);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_CLEAR_SINGLE_SM_ERROR_STATE, 137);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SET_MODE_ERRBAR_DEBUG, 138);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SET_NEXT_STOP_TRIGGER_TYPE, 139);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_ALLOC_PMA_STREAM, 140);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PMA_STREAM_UPDATE_GET_PUT, 141);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FB_GET_INFO_V2, 142);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FIFO_SET_CHANNEL_PROPERTIES, 143);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_GET_CTX_BUFFER_INFO, 144);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_KGR_GET_CTX_BUFFER_PTES, 145);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_EVICT_CTX, 146);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FB_GET_FS_INFO, 147);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GRMGR_GET_GR_FS_INFO, 148);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_STOP_CHANNEL, 149);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_PC_SAMPLING_MODE, 150);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PERF_RATED_TDP_GET_STATUS, 151);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PERF_RATED_TDP_SET_CONTROL, 152);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FREE_PMA_STREAM, 153);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_TIMER_SET_GR_TICK_FREQ, 154);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB, 155);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_CONSOLIDATED_GR_STATIC_INFO, 156);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SET_SINGLE_SM_SINGLE_STEP, 157);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_GET_TPC_PARTITION_MODE, 158);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GR_SET_TPC_PARTITION_MODE, 159);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_PAGING_CHANNEL_ALLOCATE, 160);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_PAGING_CHANNEL_DESTROY, 161);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_PAGING_CHANNEL_MAP, 162);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_PAGING_CHANNEL_UNMAP, 163);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_PAGING_CHANNEL_PUSH_STREAM, 164);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_PAGING_CHANNEL_SET_HANDLES, 165);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UVM_METHOD_STREAM_GUEST_PAGES_OPERATION, 166);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_INTERNAL_QUIESCE_PMA_CHANNEL, 167);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DCE_RM_INIT, 168);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_REGISTER_VIRTUAL_EVENT_BUFFER, 169);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_EVENT_BUFFER_UPDATE_GET, 170);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_PLCABLE_ADDRESS_KIND, 171);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PERF_LIMITS_SET_STATUS_V2, 172);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_INTERNAL_SRIOV_PROMOTE_PMA_STREAM, 173);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_MMU_DEBUG_MODE, 174);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_INTERNAL_PROMOTE_FAULT_METHOD_BUFFERS, 175);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FLCN_GET_CTX_BUFFER_SIZE, 176);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FLCN_GET_CTX_BUFFER_INFO, 177);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_DISABLE_CHANNELS, 178);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FABRIC_MEMORY_DESCRIBE, 179);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FABRIC_MEM_STATS, 180);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SAVE_HIBERNATION_DATA, 181);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RESTORE_HIBERNATION_DATA, 182);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED, 183);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_EXEC_PARTITIONS_CREATE, 184);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_EXEC_PARTITIONS_DELETE, 185);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPFIFO_GET_WORK_SUBMIT_TOKEN, 186);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPFIFO_SET_WORK_SUBMIT_TOKEN_NOTIF_INDEX, 187);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_PMA_SCRUBBER_SHARED_BUFFER_GUEST_PAGES_OPERATION, 188);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_MASTER_GET_VIRTUAL_FUNCTION_ERROR_CONT_INTR_MASK, 189);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_SET_SYSMEM_DIRTY_PAGE_TRACKING_BUFFER, 190);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SUBDEVICE_GET_P2P_CAPS, 191);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_BUS_SET_P2P_MAPPING, 192);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_BUS_UNSET_P2P_MAPPING, 193);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK, 194);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_MIGRATABLE_OPS, 195);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_TOTAL_HS_CREDITS, 196);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GET_HS_CREDITS, 197);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_HS_CREDITS, 198);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_PM_AREA_PC_SAMPLER, 199);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_INVALIDATE_TLB, 200);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_QUERY_ECC_STATUS, 201);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_ECC_NOTIFIER_WRITE_ACK, 202);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_GET_MODE_MMU_DEBUG, 203);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RM_API_CONTROL, 204);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CMD_INTERNAL_GPU_START_FABRIC_PROBE, 205);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_NVLINK_GET_INBAND_RECEIVED_DATA, 206);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_STATIC_DATA, 207);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_RESERVED_208, 208);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_GPU_GET_INFO_V2, 209);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_GET_BRAND_CAPS, 210);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CMD_NVLINK_INBAND_SEND_DATA, 211);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_UPDATE_GPM_GUEST_BUFFER_INFO, 212);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_CMD_INTERNAL_CONTROL_GSP_TRACE, 213);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SET_ZBC_STENCIL_CLEAR, 214);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SUBDEVICE_GET_VGPU_HEAP_STATS, 215);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_SUBDEVICE_GET_LIBOS_HEAP_STATS, 216);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_SET_MODE_MMU_GCC_DEBUG, 217);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_DBG_GET_MODE_MMU_GCC_DEBUG, 218);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RESERVE_HES, 219);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RELEASE_HES, 220);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RESERVE_CCU_PROF, 221);
ABI_CHECK_ENUM_VAL_EQ(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_CTRL_RELEASE_CCU_PROF, 222);
// Appending to the end of this enum is okay.
ABI_CHECK_ENUM_VAL_GE(NV_VGPU_MSG_FUNCTION, NV_VGPU_MSG_FUNCTION_NUM_FUNCTIONS, 223);



ABI_CHECK_SIZE_EQ(Nv2080DpIrqNotification, 4);
ABI_CHECK_FIELD(Nv2080DpIrqNotification, displayId, 0, 4);


ABI_CHECK_SIZE_EQ(Nv2080HotplugNotification, 8);
ABI_CHECK_FIELD(Nv2080HotplugNotification, plugDisplayMask, 0, 4);
ABI_CHECK_FIELD(Nv2080HotplugNotification, unplugDisplayMask, 4, 4);


ABI_CHECK_SIZE_EQ(PACKED_REGISTRY_ENTRY, 16);
ABI_CHECK_FIELD(PACKED_REGISTRY_ENTRY, nameOffset, 0, 4);
ABI_CHECK_FIELD(PACKED_REGISTRY_ENTRY, type, 4, 1);
ABI_CHECK_FIELD(PACKED_REGISTRY_ENTRY, data, 8, 4);
ABI_CHECK_FIELD(PACKED_REGISTRY_ENTRY, length, 12, 4);


ABI_CHECK_SIZE_EQ(PACKED_REGISTRY_TABLE, 8);
ABI_CHECK_FIELD(PACKED_REGISTRY_TABLE, size, 0, 4);
ABI_CHECK_FIELD(PACKED_REGISTRY_TABLE, numEntries, 4, 4);
ABI_CHECK_FIELD(PACKED_REGISTRY_TABLE, entries, 8, 0);

#define RM_ENGINE_TYPE_BSP RM_ENGINE_TYPE_NVDEC0
#define RM_ENGINE_TYPE_CIPHER RM_ENGINE_TYPE_TSEC
#define RM_ENGINE_TYPE_COPY(i) (RM_ENGINE_TYPE_COPY0+(i))
#define RM_ENGINE_TYPE_COPY_IDX(i) ((i) - RM_ENGINE_TYPE_COPY0)
#define RM_ENGINE_TYPE_COPY_SIZE 20
#define RM_ENGINE_TYPE_GR(i) (RM_ENGINE_TYPE_GR0 + (i))
#define RM_ENGINE_TYPE_GRAPHICS RM_ENGINE_TYPE_GR0
#define RM_ENGINE_TYPE_GR_IDX(i) ((i) - RM_ENGINE_TYPE_GR0)
#define RM_ENGINE_TYPE_GR_SIZE 8
#define RM_ENGINE_TYPE_IS_COPY(i) (((i) >= RM_ENGINE_TYPE_COPY0) && ((i) < RM_ENGINE_TYPE_COPY(RM_ENGINE_TYPE_COPY_SIZE)))
#define RM_ENGINE_TYPE_IS_GR(i) (((i) >= RM_ENGINE_TYPE_GR0) && ((i) < RM_ENGINE_TYPE_GR(RM_ENGINE_TYPE_GR_SIZE)))
#define RM_ENGINE_TYPE_IS_NVDEC(i) (((i) >= RM_ENGINE_TYPE_NVDEC0) && ((i) < RM_ENGINE_TYPE_NVDEC(RM_ENGINE_TYPE_NVDEC_SIZE)))
#define RM_ENGINE_TYPE_IS_NVENC(i) (((i) >= RM_ENGINE_TYPE_NVENC0) && ((i) < RM_ENGINE_TYPE_NVENC(RM_ENGINE_TYPE_NVENC_SIZE)))
#define RM_ENGINE_TYPE_IS_NVJPEG(i) (((i) >= RM_ENGINE_TYPE_NVJPEG0) && ((i) < RM_ENGINE_TYPE_NVJPEG(RM_ENGINE_TYPE_NVJPEG_SIZE)))
#define RM_ENGINE_TYPE_IS_OFA(i) (((i) >= RM_ENGINE_TYPE_OFA0) && ((i) < RM_ENGINE_TYPE_OFA(RM_ENGINE_TYPE_OFA_SIZE)))
#define RM_ENGINE_TYPE_IS_VALID(i) (((i) > (RM_ENGINE_TYPE_NULL)) && ((i) < (RM_ENGINE_TYPE_LAST)))
#define RM_ENGINE_TYPE_IS_VIDEO(i) (RM_ENGINE_TYPE_IS_NVENC(i) | RM_ENGINE_TYPE_IS_NVDEC(i) | RM_ENGINE_TYPE_IS_NVJPEG(i) | RM_ENGINE_TYPE_IS_OFA(i))
#define RM_ENGINE_TYPE_MSENC RM_ENGINE_TYPE_NVENC0
#define RM_ENGINE_TYPE_NVDEC(i) (RM_ENGINE_TYPE_NVDEC0+(i))
#define RM_ENGINE_TYPE_NVDEC_IDX(i) ((i) - RM_ENGINE_TYPE_NVDEC0)
#define RM_ENGINE_TYPE_NVDEC_SIZE 8
#define RM_ENGINE_TYPE_NVENC(i) (RM_ENGINE_TYPE_NVENC0+(i))
#define RM_ENGINE_TYPE_NVENC_IDX(i) ((i) - RM_ENGINE_TYPE_NVENC0)
#define RM_ENGINE_TYPE_NVENC_SIZE 4
#define RM_ENGINE_TYPE_NVJPEG(i) (RM_ENGINE_TYPE_NVJPEG0+(i))
#define RM_ENGINE_TYPE_NVJPEG_IDX(i) ((i) - RM_ENGINE_TYPE_NVJPEG0)
#define RM_ENGINE_TYPE_NVJPEG_SIZE 8
#define RM_ENGINE_TYPE_NVJPG RM_ENGINE_TYPE_NVJPEG0
#define RM_ENGINE_TYPE_OFA(i) (RM_ENGINE_TYPE_OFA0+(i))
#define RM_ENGINE_TYPE_OFA_IDX(i) ((i) - RM_ENGINE_TYPE_OFA0)
#define RM_ENGINE_TYPE_OFA_SIZE 2

ABI_CHECK_SIZE_EQ(RM_RISCV_UCODE_DESC, 84);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, version, 0, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, bootloaderOffset, 4, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, bootloaderSize, 8, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, bootloaderParamOffset, 12, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, bootloaderParamSize, 16, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, riscvElfOffset, 20, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, riscvElfSize, 24, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, appVersion, 28, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, manifestOffset, 32, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, manifestSize, 36, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, monitorDataOffset, 40, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, monitorDataSize, 44, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, monitorCodeOffset, 48, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, monitorCodeSize, 52, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, bIsMonitorEnabled, 56, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, swbromCodeOffset, 60, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, swbromCodeSize, 64, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, swbromDataOffset, 68, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, swbromDataSize, 72, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, fbReservedSize, 76, 4);
ABI_CHECK_FIELD(RM_RISCV_UCODE_DESC, bSignedAsCode, 80, 4);


ABI_CHECK_SIZE_EQ(UpdateBarPde_v15_00, 24);
ABI_CHECK_FIELD(UpdateBarPde_v15_00, barType, 0, 4);
ABI_CHECK_FIELD(UpdateBarPde_v15_00, entryValue, 8, 8);
ABI_CHECK_FIELD(UpdateBarPde_v15_00, entryLevelShift, 16, 8);


ABI_CHECK_SIZE_EQ(VIRTUAL_DISPLAY_GET_MAX_RESOLUTION_PARAMS, 12);
ABI_CHECK_FIELD(VIRTUAL_DISPLAY_GET_MAX_RESOLUTION_PARAMS, headIndex, 0, 4);
ABI_CHECK_FIELD(VIRTUAL_DISPLAY_GET_MAX_RESOLUTION_PARAMS, maxHResolution, 4, 4);
ABI_CHECK_FIELD(VIRTUAL_DISPLAY_GET_MAX_RESOLUTION_PARAMS, maxVResolution, 8, 4);


ABI_CHECK_SIZE_EQ(VIRTUAL_DISPLAY_GET_NUM_HEADS_PARAMS, 8);
ABI_CHECK_FIELD(VIRTUAL_DISPLAY_GET_NUM_HEADS_PARAMS, numHeads, 0, 4);
ABI_CHECK_FIELD(VIRTUAL_DISPLAY_GET_NUM_HEADS_PARAMS, maxNumHeads, 4, 4);


ABI_CHECK_SIZE_EQ(msgqRxHeader, 4);
ABI_CHECK_FIELD(msgqRxHeader, readPtr, 0, 4);


ABI_CHECK_SIZE_EQ(msgqTxHeader, 32);
ABI_CHECK_FIELD(msgqTxHeader, version, 0, 4);
ABI_CHECK_FIELD(msgqTxHeader, size, 4, 4);
ABI_CHECK_FIELD(msgqTxHeader, msgSize, 8, 4);
ABI_CHECK_FIELD(msgqTxHeader, msgCount, 12, 4);
ABI_CHECK_FIELD(msgqTxHeader, writePtr, 16, 4);
ABI_CHECK_FIELD(msgqTxHeader, flags, 20, 4);
ABI_CHECK_FIELD(msgqTxHeader, rxHdrOff, 24, 4);
ABI_CHECK_FIELD(msgqTxHeader, entryOff, 28, 4);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_alloc_memory_v13_01, 56);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, hClient, 0, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, hDevice, 4, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, hMemory, 8, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, hClass, 12, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, flags, 16, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, pteAdjust, 20, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, format, 24, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, length, 32, 8);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, pageCount, 40, 4);
ABI_CHECK_FIELD(rpc_alloc_memory_v13_01, pteDesc, 48, 8);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_free_v03_00, 16);
ABI_CHECK_FIELD(rpc_free_v03_00, params, 0, 16);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_gsp_rm_alloc_v03_00, 32);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, hClient, 0, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, hParent, 4, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, hObject, 8, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, hClass, 12, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, status, 16, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, paramsSize, 20, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, flags, 24, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_alloc_v03_00, reserved, 28, 4);
ABI_CHECK_FIELD_FLEXIBLE(rpc_gsp_rm_alloc_v03_00, params, 32);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_gsp_rm_control_v03_00, 24);
ABI_CHECK_FIELD(rpc_gsp_rm_control_v03_00, hClient, 0, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_control_v03_00, hObject, 4, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_control_v03_00, cmd, 8, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_control_v03_00, status, 12, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_control_v03_00, paramsSize, 16, 4);
ABI_CHECK_FIELD(rpc_gsp_rm_control_v03_00, flags, 20, 4);
ABI_CHECK_FIELD_FLEXIBLE(rpc_gsp_rm_control_v03_00, params, 24);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_os_error_log_v17_00, 268);
ABI_CHECK_FIELD(rpc_os_error_log_v17_00, exceptType, 0, 4);
ABI_CHECK_FIELD(rpc_os_error_log_v17_00, runlistId, 4, 4);
ABI_CHECK_FIELD(rpc_os_error_log_v17_00, chid, 8, 4);
ABI_CHECK_FIELD(rpc_os_error_log_v17_00, errString, 12, 256);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_post_event_v17_00, 32);
ABI_CHECK_FIELD(rpc_post_event_v17_00, hClient, 0, 4);
ABI_CHECK_FIELD(rpc_post_event_v17_00, hEvent, 4, 4);
ABI_CHECK_FIELD(rpc_post_event_v17_00, notifyIndex, 8, 4);
ABI_CHECK_FIELD(rpc_post_event_v17_00, data, 12, 4);
ABI_CHECK_FIELD(rpc_post_event_v17_00, info16, 16, 2);
ABI_CHECK_FIELD(rpc_post_event_v17_00, status, 20, 4);
ABI_CHECK_FIELD(rpc_post_event_v17_00, eventDataSize, 24, 4);
ABI_CHECK_FIELD(rpc_post_event_v17_00, bNotifyList, 28, 1);
ABI_CHECK_FIELD_FLEXIBLE(rpc_post_event_v17_00, eventData, 29);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_rc_triggered_v17_02, 48);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, nv2080EngineType, 0, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, chid, 4, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, gfid, 8, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, exceptLevel, 12, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, exceptType, 16, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, scope, 20, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, partitionAttributionId, 24, 2);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, mmuFaultAddrLo, 28, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, mmuFaultAddrHi, 32, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, mmuFaultType, 36, 4);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, bCallbackNeeded, 40, 1);
ABI_CHECK_FIELD(rpc_rc_triggered_v17_02, rcJournalBufferSize, 44, 4);
ABI_CHECK_FIELD_FLEXIBLE(rpc_rc_triggered_v17_02, rcJournalBuffer, 48);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_run_cpu_sequencer_v17_00, 40);
ABI_CHECK_FIELD(rpc_run_cpu_sequencer_v17_00, bufferSizeDWord, 0, 4);
ABI_CHECK_FIELD(rpc_run_cpu_sequencer_v17_00, cmdIndex, 4, 4);
ABI_CHECK_FIELD(rpc_run_cpu_sequencer_v17_00, regSaveArea, 8, 32);
ABI_CHECK_FIELD_FLEXIBLE(rpc_run_cpu_sequencer_v17_00, commandBuffer, 40);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_unloading_guest_driver_v1F_07, 8);
ABI_CHECK_FIELD(rpc_unloading_guest_driver_v1F_07, bInPMTransition, 0, 1);
ABI_CHECK_FIELD(rpc_unloading_guest_driver_v1F_07, bGc6Entering, 1, 1);
ABI_CHECK_FIELD(rpc_unloading_guest_driver_v1F_07, newLevel, 4, 4);


// Appending to the end of the struct is okay.
ABI_CHECK_SIZE_GE(rpc_update_bar_pde_v15_00, 24);
ABI_CHECK_FIELD(rpc_update_bar_pde_v15_00, info, 0, 24);


