From c5069d75793e360463ecbd14e6593e245a7151b6 Mon Sep 17 00:00:00 2001
From: Sarah Day <sarahday@mit.edu>
Date: Fri, 4 Dec 2015 12:36:33 -0500
Subject: [PATCH] Search for LDAP core schema in t_kdb.py

The t_kdb.py python test was hardcoded to search for the LDAP
core.schema file in a single place.  OpenLDAP can be installed in more
than one place.  Add a check which looks in several of these common
installation locations to find the core schema file.
---
 src/tests/t_kdb.py | 9 ++++++---
 1 file changed, 6 insertions(+), 3 deletions(-)

diff --git a/src/tests/t_kdb.py b/src/tests/t_kdb.py
index 28c672ce340..2d2d675de3c 100755
--- a/src/tests/t_kdb.py
+++ b/src/tests/t_kdb.py
@@ -1,6 +1,7 @@
 #!/usr/bin/python
 from k5test import *
 import time
+from itertools import imap
 
 # Run kdbtest against the BDB module.
 realm = K5Realm(create_kdb=False)
@@ -41,9 +42,11 @@
 shutil.copy(system_slapd, slapd)
 
 # Find the core schema file if we can.
-core_schema = None
-if os.path.isfile('/etc/ldap/schema/core.schema'):
-    core_schema = '/etc/ldap/schema/core.schema'
+ldap_homes = ['/etc/ldap', '/etc/openldap', '/usr/local/etc/openldap',
+              '/usr/local/etc/ldap']
+local_schema_path = '/schema/core.schema'
+core_schema = next((i for i in imap(lambda x:x+local_schema_path, ldap_homes)
+                    if os.path.isfile(i)), None)
 
 # Make a slapd config file.  This is deprecated in OpenLDAP 2.3 and
 # later, but it's easier than using LDIF and slapadd.  Include some
