/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.web3d.vrml.renderer.common.input.dis.Quat4dVariable;
import org.web3d.vrml.renderer.common.input.dis.Solver;

public class OrderNQuat4dConverger {
    private int convergenceInterval;
    private Solver solver;
    private int numDerivatives;
    private Quat4dVariable primaryVariable;
    private Quat4dVariable secondaryVariable;
    private Quat4dVariable tertiaryVariable;
    private boolean converging;
    private long convergenceStartTime;

    public OrderNQuat4dConverger(int n, int n2, Solver solver) {
        this.convergenceInterval = n2;
        this.solver = solver;
        this.primaryVariable = new Quat4dVariable(n, this.solver);
        this.secondaryVariable = new Quat4dVariable(n, this.solver);
        this.tertiaryVariable = new Quat4dVariable(n, this.solver);
    }

    public void setValueAndDerivatives(Quat4d quat4d, Vector3d[] vector3dArray, long l) {
        this.primaryVariable.set(quat4d, vector3dArray, l);
        this.converging = false;
    }

    private void makeCurrent(long l) {
        if (!this.converging) {
            this.primaryVariable.makeCurrent(l);
        } else if (l - this.convergenceStartTime > (long)this.convergenceInterval) {
            this.converging = false;
            this.primaryVariable.set(this.tertiaryVariable);
            this.primaryVariable.makeCurrent(l);
        } else {
            double d = (double)(l - this.convergenceStartTime) / (double)this.convergenceInterval;
            double d2 = -2.0 * d * d * d + 3.0 * d * d;
            this.primaryVariable.interpolate(this.secondaryVariable, this.tertiaryVariable, d2, l);
        }
    }

    public void getValue(long l, Quat4d quat4d) {
        this.makeCurrent(l);
        this.primaryVariable.getValue(quat4d);
    }

    public void getDerivatives(long l, Vector3d[] vector3dArray) {
        this.makeCurrent(l);
        this.primaryVariable.getDerivatives(vector3dArray);
    }

    public void convergeTo(Quat4d quat4d, Vector3d[] vector3dArray, long l, long l2) {
        this.makeCurrent(l2);
        this.secondaryVariable.set(this.primaryVariable);
        this.tertiaryVariable.set(quat4d, vector3dArray, l);
        this.converging = true;
        this.convergenceStartTime = l2;
    }
}

